/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.events;

import io.advantageous.qbit.Factory;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.events.impl.ConditionalEventConnector;
import io.advantageous.qbit.events.spi.EventConnector;
import io.advantageous.qbit.message.Event;
import io.advantageous.qbit.service.stats.StatsCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerBuilder {
    private EventConnector eventConnector;
    private List<Predicate<Event<Object>>> eventConnectorPredicates = new ArrayList<Predicate<Event<Object>>>();
    private String name;
    private StatsCollector statsCollector;
    public static EventConnector DEFAULT_NO_EVENT_CONNECTOR = event -> {};
    public static StatsCollector DEFAULT_NO_STATS_COLLECTOR = new StatsCollector(){};
    private final Logger logger = LoggerFactory.getLogger(EventManagerBuilder.class);
    private Factory factory;

    public static EventManagerBuilder eventManagerBuilder() {
        return new EventManagerBuilder();
    }

    public Factory getFactory() {
        if (this.factory == null) {
            this.factory = QBit.factory();
        }
        return this.factory;
    }

    public EventManagerBuilder setFactory(Factory factory) {
        this.factory = factory;
        return this;
    }

    public StatsCollector getStatsCollector() {
        if (this.statsCollector == null) {
            this.logger.debug("No stats collector registered with event manager, using default NO OP stats collector");
            this.statsCollector = DEFAULT_NO_STATS_COLLECTOR;
        }
        return this.statsCollector;
    }

    public EventManagerBuilder setStatsCollector(StatsCollector statsCollector) {
        this.statsCollector = statsCollector;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public EventManagerBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public EventConnector getEventConnector() {
        if (this.eventConnector == null) {
            this.logger.debug("Event Connector is null for {} event bus, creating NoOp Event Connector", (Object)this.getName());
            this.eventConnector = DEFAULT_NO_EVENT_CONNECTOR;
        }
        return this.eventConnector;
    }

    public List<Predicate<Event<Object>>> getEventConnectorPredicates() {
        if (this.eventConnectorPredicates == null) {
            this.eventConnectorPredicates = new ArrayList<Predicate<Event<Object>>>();
        }
        return this.eventConnectorPredicates;
    }

    public EventManagerBuilder setEventConnector(EventConnector eventConnector) {
        this.eventConnector = eventConnector;
        return this;
    }

    public EventManagerBuilder setEventConnectorPredicates(List<Predicate<Event<Object>>> eventConnectorPredicates) {
        this.eventConnectorPredicates = eventConnectorPredicates;
        return this;
    }

    public EventManagerBuilder addEventConnectorPredicate(Predicate<Event<Object>> eventConnectorPredicate) {
        this.getEventConnectorPredicates().add(eventConnectorPredicate);
        return this;
    }

    public EventManager build() {
        return this.build(this.getName());
    }

    public EventManager build(String name) {
        if (this.eventConnector == null) {
            return this.getFactory().createEventManager(name, this.getEventConnector(), this.getStatsCollector());
        }
        if (this.getEventConnectorPredicates().size() == 0) {
            return this.getFactory().createEventManager(name, this.getEventConnector(), this.getStatsCollector());
        }
        Predicate<Event<Object>> mainPredicate = this.getEventConnectorPredicates().get(0);
        for (int index = 1; index < this.eventConnectorPredicates.size(); ++index) {
            mainPredicate = mainPredicate.and(this.eventConnectorPredicates.get(index));
        }
        return this.getFactory().createEventManager(name, new ConditionalEventConnector(mainPredicate, this.getEventConnector()), this.getStatsCollector());
    }
}

