/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.events.impl;

import io.advantageous.qbit.events.EventListener;
import io.advantageous.qbit.events.impl.NoOpEventConsumer;
import io.advantageous.qbit.message.Event;
import io.advantageous.qbit.service.stats.StatsCollector;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager<T> {
    private final Logger logger = LoggerFactory.getLogger(ChannelManager.class);
    private final boolean debug = this.logger.isDebugEnabled();
    private final String name;
    private final List<EventListener<T>> listeners;
    private final StatsCollector stats;
    private final String eventBusName;
    private EventListener<T> consumer;
    private int sentCount;
    private String sentCountStatKey;

    public ChannelManager(String eventBusName, String name, StatsCollector statsCollector) {
        this.logger.info("Channel {} was created", (Object)name);
        this.name = name;
        this.consumer = new NoOpEventConsumer();
        this.stats = statsCollector;
        this.eventBusName = eventBusName;
        this.listeners = new ArrayList<EventListener<T>>();
        this.sentCountStatKey = eventBusName + "." + name;
    }

    public void add(EventListener<T> eventListener) {
        if (eventListener.subscriber()) {
            if (this.debug) {
                this.logger.debug("subscription to channel <> from <> ", (Object)this.name, eventListener);
            }
            this.listeners.add(eventListener);
            this.stats.recordLevel(this.eventBusName + "::" + this.name, this.listeners.size());
        } else {
            if (this.debug) {
                this.logger.debug("consumer to channel <> from <> ", (Object)this.name, eventListener);
            }
            this.consumer = eventListener;
        }
    }

    public void remove(EventListener<T> eventListener) {
        if (eventListener.subscriber()) {
            this.logger.info("remove subscription to channel {} from {} ", (Object)this.name, eventListener);
            this.listeners.remove(eventListener);
            this.stats.recordLevel(this.eventBusName + "::" + this.name, this.listeners.size());
        } else if (this.consumer == eventListener) {
            this.logger.info("remove consumer to channel {} from {} ", (Object)this.name, eventListener);
            this.consumer = new NoOpEventConsumer();
        }
    }

    public void send(Event<T> event) {
        if (this.debug) {
            this.logger.debug("ChannelManager::send() {}", event);
        }
        ++this.sentCount;
        if (this.sentCount > 20) {
            this.stats.recordCount(this.sentCountStatKey, this.sentCount);
            this.sentCount = 0;
        }
        for (EventListener<T> listener : this.listeners) {
            try {
                listener.listen(event);
            }
            catch (Exception ex) {
                this.logger.error("Unable to send event for Channel" + this.name, (Throwable)ex);
            }
        }
        this.consumer.listen(event);
    }
}

