/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.events.impl;

import io.advantageous.qbit.events.EventBus;
import io.advantageous.qbit.events.EventListener;
import io.advantageous.qbit.events.impl.ChannelManager;
import io.advantageous.qbit.events.spi.EventConnector;
import io.advantageous.qbit.events.spi.EventTransferObject;
import io.advantageous.qbit.service.ServiceProxyUtils;
import io.advantageous.qbit.service.stats.StatsCollector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusImpl
implements EventBus {
    private final Logger logger = LoggerFactory.getLogger(EventBusImpl.class);
    private final EventConnector eventConnector;
    final Map<String, ChannelManager<Object>> channelMap = new ConcurrentHashMap<String, ChannelManager<Object>>(20);
    private final StatsCollector stats;
    private final String name;
    long messageCounter = 0L;

    public EventBusImpl(String name, EventConnector eventConnector, StatsCollector statsCollector) {
        this.name = name;
        this.eventConnector = eventConnector;
        this.stats = statsCollector;
    }

    @Override
    public <T> void register(String channelName, EventListener<T> listener) {
        this.channel(channelName).add(listener);
    }

    private ChannelManager<Object> channel(String channelName) {
        ChannelManager<Object> channelManager = this.channelMap.get(channelName);
        if (channelManager == null) {
            channelManager = new ChannelManager(this.name, channelName, this.stats);
            this.channelMap.put(channelName, channelManager);
        }
        return channelManager;
    }

    @Override
    public <T> void send(String channel, T event) {
        ++this.messageCounter;
        EventTransferObject<Object> eventMessage = new EventTransferObject<Object>(event, this.messageCounter, channel);
        try {
            this.eventConnector.forwardEvent(eventMessage);
        }
        catch (Exception ex) {
            this.logger.error("EventBus " + this.name + " :: Error sending event " + eventMessage, (Throwable)ex);
        }
        this.channel(channel).send(eventMessage);
    }

    @Override
    public <T> void unregister(String channelName, EventListener<T> listener) {
        this.channel(channelName).remove(listener);
    }

    @Override
    public void forwardEvent(EventTransferObject<Object> event) {
        if (!event.wasReplicated()) {
            this.eventConnector.forwardEvent(event);
        }
        this.channel(event.channel()).send(event);
    }

    @Override
    public void flush() {
        this.eventConnector.flush();
        ServiceProxyUtils.flushServiceProxy(this.eventConnector);
    }
}

