/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.events.impl;

import io.advantageous.boon.core.Str;
import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.client.ClientProxy;
import io.advantageous.qbit.client.RemoteTCPClientProxy;
import io.advantageous.qbit.events.spi.EventConnector;
import io.advantageous.qbit.events.spi.EventTransferObject;
import io.advantageous.qbit.service.ServiceProxyUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConnectorHub
implements EventConnector,
Iterable<EventConnector> {
    private final List<EventConnector> eventConnectors;
    private final Logger logger = LoggerFactory.getLogger(EventConnectorHub.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();

    public EventConnectorHub(List<EventConnector> eventConnectors) {
        this.eventConnectors = new CopyOnWriteArrayList<EventConnector>(eventConnectors);
    }

    public EventConnectorHub() {
        this.eventConnectors = new CopyOnWriteArrayList<EventConnector>();
    }

    public void add(EventConnector eventConnector) {
        this.eventConnectors.add(eventConnector);
    }

    public void addAll(EventConnector ... eventConnectors) {
        Collections.addAll(this.eventConnectors, eventConnectors);
    }

    public void remove(EventConnector eventConnector) {
        if (eventConnector != null) {
            try {
                if (eventConnector instanceof RemoteTCPClientProxy) {
                    RemoteTCPClientProxy remoteTCPClientProxy = (RemoteTCPClientProxy)((Object)eventConnector);
                    this.logger.info(Str.sputs((Object[])new Object[]{"Removing event connector host ", remoteTCPClientProxy.host(), " port ", remoteTCPClientProxy.port(), "connected ", remoteTCPClientProxy.connected()}));
                    remoteTCPClientProxy.silentClose();
                }
                this.eventConnectors.remove(eventConnector);
            }
            catch (Exception ex) {
                this.logger.error("Unable to remove event connector", (Throwable)ex);
            }
        }
    }

    @Override
    public void forwardEvent(EventTransferObject<Object> event) {
        if (this.debug) {
            this.logger.debug("forwardEvent " + event.channel() + " size " + this.eventConnectors.size());
        }
        for (int index = 0; index < this.eventConnectors.size(); ++index) {
            EventConnector eventConnector = null;
            try {
                eventConnector = this.eventConnectors.get(index);
                eventConnector.forwardEvent(event);
                continue;
            }
            catch (Exception ex) {
                this.logger.error("problem sending event to event connector", (Throwable)ex);
                if (!(eventConnector instanceof RemoteTCPClientProxy) || ((RemoteTCPClientProxy)((Object)eventConnector)).connected()) continue;
                this.eventConnectors.remove(eventConnector);
            }
        }
        if (this.debug) {
            this.logger.debug("forwardEvent done " + event.channel());
        }
    }

    @Override
    public void flush() {
        for (int index = 0; index < this.eventConnectors.size(); ++index) {
            EventConnector eventConnector = null;
            try {
                eventConnector = this.eventConnectors.get(index);
                if (eventConnector instanceof ClientProxy) {
                    ServiceProxyUtils.flushServiceProxy(eventConnector);
                    continue;
                }
                eventConnector.flush();
                continue;
            }
            catch (Exception ex) {
                this.logger.debug("problem sending event to event connector", (Throwable)ex);
                if (!(eventConnector instanceof RemoteTCPClientProxy) || ((RemoteTCPClientProxy)((Object)eventConnector)).connected()) continue;
                this.eventConnectors.remove(eventConnector);
            }
        }
    }

    @Override
    public Iterator<EventConnector> iterator() {
        return this.eventConnectors.listIterator();
    }

    public ListIterator<EventConnector> listIterator() {
        return this.eventConnectors.listIterator();
    }

    public int size() {
        return this.eventConnectors.size();
    }
}

