/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.events.spi;

import io.advantageous.qbit.message.Event;

public class EventTransferObject<T>
implements Event<T> {
    private final T body;
    private final long id;
    private final String topic;

    public EventTransferObject(T body, long id, String topic) {
        this.body = body;
        this.id = id;
        this.topic = topic;
    }

    public EventTransferObject() {
        this.body = null;
        this.id = 0L;
        this.topic = "";
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public T body() {
        return this.body;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String toString() {
        return "EventImpl{body=" + this.body + ", id=" + this.id + '}';
    }

    @Override
    public String channel() {
        return this.topic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        if (this.id != event.id()) {
            return false;
        }
        return !(this.topic == null ? event.channel() != null : !this.topic.equals(event.channel()));
    }

    public int hashCode() {
        int result = this.body != null ? this.body.hashCode() : 0;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        return result;
    }
}

