/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http;

import io.advantageous.boon.core.Conversions;
import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.IO;
import io.advantageous.boon.core.Maps;
import io.advantageous.boon.core.Sys;
import io.advantageous.boon.primitive.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HTTP {
    public static final int DEFAULT_TIMEOUT_SECONDS = Sys.sysProp((String)"HTTP.timeout.seconds", (int)180);
    public static final String APPLICATION_JSON = "application/json";

    public static String get(final String url) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                Map accept = Maps.map((Object)"Accept", (Object)"text/html,application/xhtml+xml,application/xml,application/json,text/plain;");
                URLConnection connection = HTTP.doGet(url, accept, null, null);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String post(String url, String body) {
        return HTTP.postBodyTextWithContentType(url, "text/plain", body);
    }

    public static Response getResponse(final String url) {
        return (Response)Exceptions.tryIt(Response.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<Response>(){

            public Response tryIt() throws Exception {
                Map accept = Maps.map((Object)"Accept", (Object)"text/html,application/xhtml+xml,application/xml,application/json,text/plain;");
                URLConnection connection = HTTP.doGet(url, accept, null, null);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static Response deleteResponse(final String url) {
        return (Response)Exceptions.tryIt(Response.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<Response>(){

            public Response tryIt() throws Exception {
                Map accept = Maps.map((Object)"Accept", (Object)"text/html,application/xhtml+xml,application/xml,application/json,text/plain;");
                URLConnection connection = HTTP.doDelete(url, accept, null, null);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static byte[] getBytes(final String url, final String contentType) {
        return (byte[])Exceptions.tryIt(byte[].class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<byte[]>(){

            public byte[] tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, null, contentType, null, true);
                return HTTP.extractResponseBytes(connection);
            }
        });
    }

    public static byte[] getBytesUsingHeaders(final String url, final String contentType, final Map<String, ?> headers) {
        return (byte[])Exceptions.tryIt(byte[].class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<byte[]>(){

            public byte[] tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, contentType, null, true);
                return HTTP.extractResponseBytes(connection);
            }
        });
    }

    public static String getWithHeaders(final String url, final Map<String, ?> headers) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, null, null);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String getWithContentTypeHeaders(final String url, final Map<String, ?> headers, final String contentType) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, contentType, null);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String getWithCharSet(final String url, final Map<String, ?> headers, final String contentType, final String charSet) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, contentType, charSet);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postText(String url, String body) {
        return HTTP.postBodyTextWithContentType(url, "text/plain", body);
    }

    public static String postBodyTextWithContentType(final String url, final String contentType, final String body) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, null, contentType, null, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String putBodyTextWithContentType(final String url, final String contentType, final String body) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, null, contentType, null, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postJSON(String url, String jsonString) {
        return HTTP.postBodyTextWithContentType(url, APPLICATION_JSON, jsonString);
    }

    public static String putJSON(String url, String jsonString) {
        return HTTP.putBodyTextWithContentType(url, APPLICATION_JSON, jsonString);
    }

    public static Response jsonRestCallViaPOST(String url, String jsonString) {
        return HTTP.postBodyTextWithContentTypeReturnResponse(url, APPLICATION_JSON, jsonString);
    }

    public static Response jsonRestCallViaPUT(String url, String jsonString) {
        return HTTP.putBodyTextWithContentTypeReturnResponse(url, APPLICATION_JSON, jsonString);
    }

    public static String getJSON(final String url, final Map<String, ?> headers) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, HTTP.APPLICATION_JSON, null);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static Response jsonRestCallWithHeaders(final String url, final Map<String, ?> headers) {
        return (Response)Exceptions.tryIt(Response.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<Response>(){

            public Response tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, HTTP.APPLICATION_JSON, null);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static Response jsonRestCall(final String url) {
        return (Response)Exceptions.tryIt(Response.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<Response>(){

            public Response tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, null, HTTP.APPLICATION_JSON, null);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static Response postBodyTextWithContentTypeReturnResponse(final String url, final String contentType, final String body) {
        return (Response)Exceptions.tryIt(Response.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<Response>(){

            public Response tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, null, contentType, null, body);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static Response putBodyTextWithContentTypeReturnResponse(final String url, final String contentType, final String body) {
        return (Response)Exceptions.tryIt(Response.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<Response>(){

            public Response tryIt() throws Exception {
                URLConnection connection = HTTP.doPut(url, null, contentType, null, body);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static String getJSONWithParams(final String url, final Map<String, ?> headers, final Map<String, ?> params) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, HTTP.APPLICATION_JSON, null, params);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postXML(String url, String jsonString) {
        return HTTP.postBodyTextWithContentType(url, "text/xml", jsonString);
    }

    public static String postWithHeaders(final String url, final Map<String, ?> headers, final String body) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, headers, "text/plain", null, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postWithContentType(final String url, final Map<String, ?> headers, final String contentType, final String body) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, headers, contentType, null, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postWithCharset(final String url, final Map<String, ?> headers, final String contentType, final String charSet, final String body) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, headers, contentType, charSet, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    private static URLConnection doPost(String url, Map<String, ?> headers, String contentType, String charset, String body) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        connection.setDoOutput(true);
        HTTP.manageContentTypeHeaders(contentType, charset, connection);
        HTTP.manageHeaders(headers, connection);
        IO.write((OutputStream)connection.getOutputStream(), (String)body, (Charset)IO.DEFAULT_CHARSET);
        return connection;
    }

    private static URLConnection doPut(String url, Map<String, ?> headers, String contentType, String charset, String body) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        HTTP.manageContentTypeHeaders(contentType, charset, connection);
        HTTP.manageHeaders(headers, connection);
        IO.write((OutputStream)connection.getOutputStream(), (String)body, (Charset)IO.DEFAULT_CHARSET);
        return connection;
    }

    public static String postForm(final String url, final Map<String, ?> headers, final Map<String, Object> formData) {
        return (String)Exceptions.tryIt(String.class, (Exceptions.TrialWithReturn)new Exceptions.TrialWithReturn<String>(){

            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPostFormData(url, headers, formData);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    private static URLConnection doPostFormData(String url, Map<String, ?> headers, Map<String, Object> formData) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        connection.setDoOutput(true);
        connection.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        ByteBuf buf = ByteBuf.create((int)244);
        Set<String> keys = formData.keySet();
        int index = 0;
        for (String key : keys) {
            Object value = formData.get(key);
            if (index > 0) {
                buf.addByte(38);
            }
            buf.addUrlEncoded(key);
            buf.addByte(61);
            if (!(value instanceof byte[])) {
                buf.addUrlEncoded(value.toString());
            } else {
                buf.addUrlEncodedByteArray((byte[])value);
            }
            ++index;
        }
        HTTP.manageContentTypeHeaders("application/x-www-form-urlencoded", StandardCharsets.UTF_8.name(), connection);
        HTTP.manageHeaders(headers, connection);
        int len = buf.len();
        IO.write((OutputStream)connection.getOutputStream(), (String)new String(buf.readForRecycle(), 0, len, StandardCharsets.UTF_8), (Charset)IO.DEFAULT_CHARSET);
        return connection;
    }

    private static void manageHeaders(Map<String, ?> headers, URLConnection connection) {
        if (headers != null) {
            for (Map.Entry<String, ?> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue().toString());
            }
        }
    }

    private static void manageContentTypeHeaders(String contentType, String charset, URLConnection connection, boolean binary) {
        if (!binary) {
            connection.setRequestProperty("Accept-Charset", charset == null ? StandardCharsets.UTF_8.displayName() : charset);
        }
        if (contentType != null && !contentType.isEmpty()) {
            connection.setRequestProperty("Content-Type", contentType);
        }
    }

    private static URLConnection doGet(String url, Map<String, ?> headers, String contentType, String charset, boolean binary) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        HTTP.manageContentTypeHeaders(contentType, charset, connection, binary);
        HTTP.manageHeaders(headers, connection);
        return connection;
    }

    private static String extractResponseString(URLConnection connection) throws IOException {
        HttpURLConnection http = (HttpURLConnection)connection;
        int status = http.getResponseCode();
        String charset = HTTP.getCharset(connection.getHeaderField("Content-Type"));
        if (status == 200) {
            return HTTP.readResponseBody(http, charset);
        }
        return HTTP.readErrorResponseBody(http, status, charset);
    }

    private static Response extractResponseObject(URLConnection connection) throws IOException {
        HttpURLConnection http = (HttpURLConnection)connection;
        int status = http.getResponseCode();
        String charset = HTTP.getCharset(connection.getHeaderField("Content-Type"));
        String body = status == 200 ? HTTP.readResponseBody(http, charset) : HTTP.readErrorResponseBodyDoNotDie(http, status, charset);
        return Response.response(status, http.getHeaderFields(), http.getResponseMessage(), body);
    }

    private static byte[] extractResponseBytes(URLConnection connection) throws IOException {
        HttpURLConnection http = (HttpURLConnection)connection;
        int status = http.getResponseCode();
        if (status == 200) {
            return HTTP.readResponseBodyAsBytes(http);
        }
        String charset = HTTP.getCharset(connection.getHeaderField("Content-Type"));
        HTTP.readErrorResponseBody(http, status, charset);
        return null;
    }

    private static byte[] readResponseBodyAsBytes(HttpURLConnection http) {
        try {
            return IO.input((InputStream)http.getInputStream());
        }
        catch (IOException e) {
            return (byte[])Exceptions.handle(byte[].class, (Exception)e);
        }
    }

    private static String readErrorResponseBody(HttpURLConnection http, int status, String charset) {
        InputStream errorStream = http.getErrorStream();
        if (errorStream != null) {
            String error = charset == null ? IO.read((InputStream)errorStream) : IO.read((InputStream)errorStream, (String)charset);
            return (String)Exceptions.die(String.class, (String)("STATUS CODE =" + status + "\n\n" + error));
        }
        return (String)Exceptions.die(String.class, (String)("STATUS CODE =" + status));
    }

    private static String readErrorResponseBodyDoNotDie(HttpURLConnection http, int status, String charset) {
        InputStream errorStream = http.getErrorStream();
        if (errorStream != null) {
            String error = charset == null ? IO.read((InputStream)errorStream) : IO.read((InputStream)errorStream, (String)charset);
            return error;
        }
        return "";
    }

    private static String readResponseBody(HttpURLConnection http, String charset) throws IOException {
        if (charset != null) {
            return IO.read((InputStream)http.getInputStream(), (String)charset);
        }
        return IO.read((InputStream)http.getInputStream());
    }

    private static String getCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        String charset = null;
        for (String param : contentType.replace(" ", "").split(";")) {
            if (!param.startsWith("charset=")) continue;
            charset = param.split("=", 2)[1];
            break;
        }
        charset = charset == null ? StandardCharsets.UTF_8.displayName() : charset;
        return charset;
    }

    private static void manageContentTypeHeaders(String contentType, String charset, URLConnection connection) {
        connection.setRequestProperty("Accept-Charset", charset == null ? StandardCharsets.UTF_8.displayName() : charset);
        if (contentType != null && !contentType.isEmpty()) {
            connection.setRequestProperty("Content-Type", contentType);
        }
    }

    private static URLConnection doGet(String url, Map<String, ?> headers, String contentType, String charset) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        HTTP.manageContentTypeHeaders(contentType, charset, connection);
        HTTP.manageHeaders(headers, connection);
        return connection;
    }

    private static URLConnection doDelete(String url, Map<String, ?> headers, String contentType, String charset) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        connection.setRequestMethod("DELETE");
        HTTP.manageContentTypeHeaders(contentType, charset, connection);
        HTTP.manageHeaders(headers, connection);
        return connection;
    }

    private static URLConnection doGet(String url, Map<String, ?> headers, String contentType, String charset, Map<String, ?> params) throws IOException {
        if (charset == null) {
            charset = StandardCharsets.UTF_8.name();
        }
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        HTTP.manageContentTypeHeaders(contentType, charset, connection);
        HTTP.manageHeaders(headers, connection);
        Set<String> keys = params.keySet();
        for (String key : keys) {
            Object value = params.get(key);
            connection.addRequestProperty(URLEncoder.encode(key, charset), URLEncoder.encode(value.toString(), charset));
        }
        return connection;
    }

    public static class Response {
        private final int status;
        private final Map<String, List<String>> headers;
        private final Object statusMessage;
        private final Object payload;
        private final Class<? extends Enum> enumStatusClass;

        public Response(int status, Map<String, List<String>> headers, Object statusMessage, Object payload) {
            this.status = status;
            this.headers = headers;
            this.statusMessage = statusMessage;
            this.payload = payload;
            this.enumStatusClass = null;
        }

        public Response(int status, Map<String, List<String>> headers, Object statusMessage, Object payload, Class<? extends Enum> enumStatusClass) {
            this.status = status;
            this.headers = headers;
            this.statusMessage = statusMessage;
            this.payload = payload;
            this.enumStatusClass = enumStatusClass;
        }

        public int status() {
            return this.status;
        }

        public <E extends Enum> E statusEnum(Class<E> enumClass) {
            return (E)Conversions.toEnum(enumClass, (int)this.status);
        }

        public Enum statusEnum() {
            return Conversions.toEnum(this.enumStatusClass, (int)this.status);
        }

        public Map<String, List<String>> headers() {
            return this.headers;
        }

        public Map<String, Object> headerMap() {
            return Conversions.toMap(this.headers);
        }

        public Object statusMessage() {
            return this.statusMessage;
        }

        public String statusMessageAsString() {
            return Conversions.toString((Object)this.statusMessage);
        }

        public Object payload() {
            return this.payload;
        }

        public String payloadAsString() {
            return Conversions.toString((Object)this.payload);
        }

        public String body() {
            return this.payloadAsString();
        }

        public int code() {
            return this.status();
        }

        public static Response response(int status, Map<String, List<String>> headers, String statusMessage, String payload) {
            return new Response(status, headers, statusMessage, payload);
        }
    }
}

