/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.client;

import io.advantageous.boon.core.Sys;
import io.advantageous.boon.core.reflection.BeanUtils;
import io.advantageous.qbit.http.client.HttpClientClosedConnectionException;
import io.advantageous.qbit.http.client.HttpClientTimeoutException;
import io.advantageous.qbit.http.request.HttpBinaryReceiver;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.http.request.HttpRequestBuilder;
import io.advantageous.qbit.http.request.HttpResponseReceiver;
import io.advantageous.qbit.http.request.HttpTextReceiver;
import io.advantageous.qbit.http.request.HttpTextResponse;
import io.advantageous.qbit.http.websocket.WebSocket;
import io.advantageous.qbit.service.ServiceFlushable;
import io.advantageous.qbit.service.Startable;
import io.advantageous.qbit.service.Stoppable;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.Timer;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public interface HttpClient
extends ServiceFlushable,
Stoppable,
Startable {
    public static final int HTTP_CLIENT_DEFAULT_TIMEOUT = Sys.sysProp((String)"io.advantageous.qbit.http.client.HttpClient.timeout", (int)180);

    default public boolean isClosed() {
        return false;
    }

    default public void checkClosed() {
        if (this.isClosed()) {
            throw new HttpClientClosedConnectionException();
        }
    }

    default public void sendHttpRequest(HttpRequest request) {
    }

    default public void sendGetRequest(String uri) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).build();
        this.sendHttpRequest(httpRequest);
    }

    default public void getAsync(String uri, HttpTextReceiver httpTextReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setTextReceiver(httpTextReceiver).build();
        this.sendHttpRequest(httpRequest);
    }

    default public void getAsyncWith1Param(String uri, String paramName0, Object value0, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith1Param(uri, "GET", paramName0, value0, httpTextReceiver);
    }

    default public void getAsyncWith2Params(String uri, String paramName0, Object value0, String paramName1, Object value1, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith2Params(uri, "GET", paramName0, value0, paramName1, value1, httpTextReceiver);
    }

    default public void getAsyncWith3Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith3Params(uri, "GET", paramName0, value0, paramName1, value1, paramName2, value2, httpTextReceiver);
    }

    default public void getAsyncWith4Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, String paramName3, Object value3, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith4Params(uri, "GET", paramName0, value0, paramName1, value1, paramName2, value2, paramName3, value3, httpTextReceiver);
    }

    default public void getAsyncWith5Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, String paramName3, Object value3, String paramName4, Object value4, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith5Params(uri, "GET", paramName0, value0, paramName1, value1, paramName2, value2, paramName3, value3, paramName4, value4, httpTextReceiver);
    }

    default public void postAsync(String uri, HttpTextReceiver httpTextReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setTextReceiver(httpTextReceiver).setMethod("POST").build();
        this.sendHttpRequest(httpRequest);
    }

    default public void postFormAsyncWith1Param(String uri, String paramName0, Object value0, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith1Param(uri, "POST", paramName0, value0, httpTextReceiver);
    }

    default public void postFormAsyncWith2Params(String uri, String paramName0, Object value0, String paramName1, Object value1, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith2Params(uri, "POST", paramName0, value0, paramName1, value1, httpTextReceiver);
    }

    default public void postFormAsyncWith3Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith3Params(uri, "POST", paramName0, value0, paramName1, value1, paramName2, value2, httpTextReceiver);
    }

    default public void postFormAsyncWith4Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, String paramName3, Object value3, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith4Params(uri, "POST", paramName0, value0, paramName1, value1, paramName2, value2, paramName3, value3, httpTextReceiver);
    }

    default public void postFormAsyncWith5Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, String paramName3, Object value3, String paramName4, Object value4, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith5Params(uri, "POST", paramName0, value0, paramName1, value1, paramName2, value2, paramName3, value3, paramName4, value4, httpTextReceiver);
    }

    default public void putAsync(String uri, HttpTextReceiver httpTextReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setTextReceiver(httpTextReceiver).setMethod("PUT").build();
        this.sendHttpRequest(httpRequest);
    }

    default public void putFormAsyncWith1Param(String uri, String paramName0, Object value0, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith1Param(uri, "PUT", paramName0, value0, httpTextReceiver);
    }

    default public void putFormAsyncWith2Params(String uri, String paramName0, Object value0, String paramName1, Object value1, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith2Params(uri, "PUT", paramName0, value0, paramName1, value1, httpTextReceiver);
    }

    default public void putFormAsyncWith3Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith3Params(uri, "PUT", paramName0, value0, paramName1, value1, paramName2, value2, httpTextReceiver);
    }

    default public void putFormAsyncWith4Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, String paramName3, Object value3, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith4Params(uri, "PUT", paramName0, value0, paramName1, value1, paramName2, value2, paramName3, value3, httpTextReceiver);
    }

    default public void putFormAsyncWith5Params(String uri, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, String paramName3, Object value3, String paramName4, Object value4, HttpTextReceiver httpTextReceiver) {
        this.sendAsyncRequestWith5Params(uri, "PUT", paramName0, value0, paramName1, value1, paramName2, value2, paramName3, value3, paramName4, value4, httpTextReceiver);
    }

    default public void sendAsyncRequestWith1Param(String uri, String method, String paramName0, Object value0, HttpTextReceiver httpTextReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod(method).setUri(uri).setTextReceiver(httpTextReceiver).addParam(paramName0, value0 == null ? "" : value0.toString()).initFormIfNeeded().build();
        this.sendHttpRequest(httpRequest);
    }

    default public void sendAsyncRequestWith2Params(String uri, String method, String paramName0, Object value0, String paramName1, Object value1, HttpTextReceiver httpTextReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod(method).setUri(uri).setTextReceiver(httpTextReceiver).addParam(paramName0, value0 == null ? "" : value0.toString()).addParam(paramName1, value1 == null ? "" : value1.toString()).initFormIfNeeded().build();
        this.sendHttpRequest(httpRequest);
    }

    default public void sendAsyncRequestWith3Params(String uri, String method, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, HttpTextReceiver httpTextReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod(method).setUri(uri).setTextReceiver(httpTextReceiver).addParam(paramName0, value0 == null ? "" : value0.toString()).addParam(paramName1, value1 == null ? "" : value1.toString()).addParam(paramName2, value2 == null ? "" : value2.toString()).initFormIfNeeded().build();
        this.sendHttpRequest(httpRequest);
    }

    default public void sendAsyncRequestWith4Params(String uri, String method, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, String paramName3, Object value3, HttpTextReceiver httpTextReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod(method).setUri(uri).setTextReceiver(httpTextReceiver).addParam(paramName0, value0 == null ? "" : value0.toString()).addParam(paramName1, value1 == null ? "" : value1.toString()).addParam(paramName2, value2 == null ? "" : value2.toString()).addParam(paramName3, value3 == null ? "" : value3.toString()).initFormIfNeeded().build();
        this.sendHttpRequest(httpRequest);
    }

    default public void sendAsyncRequestWith5Params(String uri, String method, String paramName0, Object value0, String paramName1, Object value1, String paramName2, Object value2, String paramName3, Object value3, String paramName4, Object value4, HttpTextReceiver httpTextReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod(method).setUri(uri).setTextReceiver(httpTextReceiver).addParam(paramName0, value0 == null ? "" : value0.toString()).addParam(paramName1, value1 == null ? "" : value1.toString()).addParam(paramName2, value2 == null ? "" : value2.toString()).addParam(paramName3, value3 == null ? "" : value3.toString()).addParam(paramName4, value4 == null ? "" : value4.toString()).initFormIfNeeded().build();
        this.sendHttpRequest(httpRequest);
    }

    default public void getBinaryAsync(String uri, HttpBinaryReceiver binaryReceiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setBinaryReceiver(binaryReceiver).build();
        this.sendHttpRequest(httpRequest);
    }

    default public HttpTextResponse sendRequestAndWait(HttpRequest httpRequest) {
        return this.sendRequestAndWait(httpRequest, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse sendRequestAndWait(HttpRequest httpRequest, long wait, TimeUnit timeUnit) {
        AtomicReference<HttpTextResponse> httpResponseAtomicReference;
        CountDownLatch countDownLatch;
        block4: {
            CountDownLatch countDownLatchConnect = new CountDownLatch(1);
            countDownLatch = new CountDownLatch(1);
            httpResponseAtomicReference = new AtomicReference<HttpTextResponse>();
            HttpClient._createHttpTextReceiver(httpRequest, countDownLatch, countDownLatchConnect, httpResponseAtomicReference);
            this.sendHttpRequest(httpRequest);
            try {
                countDownLatchConnect.await(500L, TimeUnit.MILLISECONDS);
                this.checkClosed();
                countDownLatch.await(wait, timeUnit);
            }
            catch (InterruptedException e) {
                if (!Thread.currentThread().isInterrupted()) break block4;
                Thread.interrupted();
            }
        }
        HttpTextResponse httpResponse = httpResponseAtomicReference.get();
        if (httpResponse == null) {
            if (countDownLatch.getCount() != 0L) {
                throw new HttpClientTimeoutException("Timeout start time " + new Date(httpRequest.getTimestamp()) + " now " + new Date(Timer.clockTime()));
            }
            throw new HttpClientTimeoutException("Timeout: no response " + new Date(httpRequest.getTimestamp()) + " now " + new Date(Timer.clockTime()));
        }
        return httpResponse;
    }

    default public HttpTextResponse get(String uri) {
        return this.getWithTimeout(uri, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse getWithTimeout(String uri, long time, TimeUnit unit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).build();
        return this.sendRequestAndWait(httpRequest, time, unit);
    }

    default public HttpTextResponse post(String uri) {
        return this.postWithTimeout(uri, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse postWithTimeout(String uri, long time, TimeUnit unit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("POST").setUri(uri).build();
        return this.sendRequestAndWait(httpRequest, time, unit);
    }

    default public HttpTextResponse put(String uri) {
        return this.postWithTimeout(uri, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse putWithTimeout(String uri, long time, TimeUnit unit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("PUT").setUri(uri).build();
        return this.sendRequestAndWait(httpRequest, time, unit);
    }

    default public HttpTextResponse getWith1ParamWithTimeout(String uri, String key, Object value, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).addParam(key, value == null ? "" : value.toString()).build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse getWith1Param(String uri, String key, Object value) {
        return this.getWith1ParamWithTimeout(uri, key, value, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse postWith1ParamWithTimeout(String uri, String key, Object value, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("POST").setUri(uri).addParam(key, value == null ? "" : value.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse postWith1Param(String uri, String key, Object value) {
        return this.postWith1ParamWithTimeout(uri, key, value, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse putWith1ParamWithTimeout(String uri, String key, Object value, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("PUT").setUri(uri).addParam(key, value == null ? "" : value.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse putWith1Param(String uri, String key, Object value) {
        return this.putWith1ParamWithTimeout(uri, key, value, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse getWith2ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse getWith2Params(String uri, String key, Object value, String key1, Object value1) {
        return this.getWith2ParamsWithTimeout(uri, key, value, key1, value1, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse postWith2ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("POST").setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse postWith2Params(String uri, String key, Object value, String key1, Object value1) {
        return this.postWith2ParamsWithTimeout(uri, key, value, key1, value1, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse putWith2ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("PUT").setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse putWith2Params(String uri, String key, Object value, String key1, Object value1) {
        return this.putWith2ParamsWithTimeout(uri, key, value, key1, value1, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse getWith3ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse getWith3Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2) {
        return this.getWith3ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse postWith3ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("POST").setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse postWith3Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2) {
        return this.postWith3ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse putWith3ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("PUT").setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse putWith3Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2) {
        return this.putWith3ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse getWith4ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).addParam(key3, value3 == null ? "" : value3.toString()).build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse getWith4Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        return this.getWith4ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, key3, value3, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse postWith4ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("POST").setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).addParam(key3, value3 == null ? "" : value3.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse postWith4Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        return this.postWith4ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, key3, value3, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse putWith4ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setMethod("PUT").setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).addParam(key3, value3 == null ? "" : value3.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse putWith4Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        return this.putWith4ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, key3, value3, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse getWith5ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).addParam(key3, value3 == null ? "" : value3.toString()).addParam(key4, value4 == null ? "" : value4.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse getWith5Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        return this.getWith5ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, key3, value3, key4, value4, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse postWith5ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setMethod("POST").addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).addParam(key3, value3 == null ? "" : value3.toString()).addParam(key4, value4 == null ? "" : value4.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse postWith5Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        return this.postWith5ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, key3, value3, key4, value4, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public HttpTextResponse putWith5ParamsWithTimeout(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, long time, TimeUnit timeUnit) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setMethod("PUT").addParam(key, value == null ? "" : value.toString()).addParam(key1, value1 == null ? "" : value1.toString()).addParam(key2, value2 == null ? "" : value2.toString()).addParam(key3, value3 == null ? "" : value3.toString()).addParam(key4, value4 == null ? "" : value4.toString()).initFormIfNeeded().build();
        return this.sendRequestAndWait(httpRequest, time, timeUnit);
    }

    default public HttpTextResponse putWith5Params(String uri, String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        return this.putWith5ParamsWithTimeout(uri, key, value, key1, value1, key2, value2, key3, value3, key4, value4, HTTP_CLIENT_DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    default public void sendPost(String uri, String contentType, String body) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setBody(body).setContentType(contentType).setMethodPost().build();
        this.sendHttpRequest(httpRequest);
    }

    default public void sendJsonPost(String uri, String body) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPost(body).setMethodPost().build();
        this.sendHttpRequest(httpRequest);
    }

    default public HttpTextResponse postJson(String uri, String body) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPost(body).setMethodPost().build();
        return this.sendRequestAndWait(httpRequest);
    }

    default public HttpTextResponse postJsonGzip(String uri, String body) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPostGzip(body).build();
        return this.sendRequestAndWait(httpRequest);
    }

    default public HttpTextResponse putJsonGzip(String uri, String body) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPutGzip(body).build();
        return this.sendRequestAndWait(httpRequest);
    }

    default public HttpTextResponse putJson(String uri, String body) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPost(body).setMethodPost().build();
        return this.sendRequestAndWait(httpRequest);
    }

    default public void sendJsonPut(String uri, String body) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPost(body).setMethodPut().build();
        this.sendHttpRequest(httpRequest);
    }

    default public void sendJsonPostAsync(String uri, String body, HttpTextReceiver receiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPost(body).setMethodPost().setTextReceiver(receiver).build();
        this.sendHttpRequest(httpRequest);
    }

    default public <T> void sendJsonGzipPostAsync(String uri, String body, HttpResponseReceiver<T> receiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPostGzip(body).receiver(receiver).build();
        this.sendHttpRequest(httpRequest);
    }

    default public <T> void sendJsonGzipPutAsync(String uri, String body, HttpResponseReceiver<T> receiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPutGzip(body).receiver(receiver).build();
        this.sendHttpRequest(httpRequest);
    }

    default public void sendJsonPutAsync(String uri, String body, HttpTextReceiver receiver) {
        HttpRequest httpRequest = HttpRequestBuilder.httpRequestBuilder().setUri(uri).setJsonBodyForPost(body).setMethodPut().setTextReceiver(receiver).build();
        this.sendHttpRequest(httpRequest);
    }

    default public WebSocket createWebSocket(String uri) {
        throw new RuntimeException("New way to send messages");
    }

    default public void periodicFlushCallback(Consumer<Void> periodicFlushCallback) {
    }

    default public int getPort() {
        return -1;
    }

    default public String getHost() {
        return "localhost";
    }

    default public HttpClient startClient() {
        return this;
    }

    @Override
    default public void flush() {
    }

    @Override
    default public void stop() {
    }

    public static void _createHttpTextReceiver(HttpRequest httpRequest, final CountDownLatch countDownLatch, final CountDownLatch countDownLatch2, final AtomicReference<HttpTextResponse> httpResponseAtomicReference) {
        HttpTextReceiver httpTextReceiver = new HttpTextReceiver(){

            @Override
            public void response(int code, String contentType, String body) {
                this.response(code, contentType, body, MultiMap.empty());
            }

            @Override
            public void response(final int code, final String contentType, final String body, final MultiMap<String, String> headers) {
                httpResponseAtomicReference.set(new HttpTextResponse(){

                    @Override
                    public MultiMap<String, String> headers() {
                        return headers;
                    }

                    @Override
                    public int code() {
                        return code;
                    }

                    @Override
                    public String contentType() {
                        return contentType;
                    }

                    @Override
                    public String body() {
                        return body;
                    }

                    public String toString() {
                        return "HttpTextResponse(code:" + code + "contentType:" + contentType + "\nbody:\n" + body + "\n)";
                    }
                });
                countDownLatch.countDown();
                countDownLatch2.countDown();
            }
        };
        BeanUtils.idx((Object)httpRequest, (String)"receiver", (Object)httpTextReceiver);
    }
}

