/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.client;

import io.advantageous.qbit.QBit;
import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.http.client.HttpClient;
import java.util.Properties;

public class HttpClientBuilder {
    public static final String QBIT_HTTP_CLIENT_BUILDER = "qbit.http.client.builder.";
    private String host = "localhost";
    private int port = 8080;
    private int poolSize = 1;
    private int timeOutInMilliseconds = 3000;
    private boolean autoFlush = true;
    private boolean keepAlive = true;
    private boolean pipeline = true;
    private int flushInterval = 50;
    private boolean ssl = false;
    private boolean verifyHost = false;
    private boolean trustAll = true;
    private int maxWebSocketFrameSize = 100000000;
    private boolean tryUseCompression;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean tcpNoDelay = true;
    private int soLinger = 100;

    public HttpClientBuilder(PropertyResolver propertyResolver) {
        this.autoFlush = propertyResolver.getBooleanProperty("autoFlush", this.autoFlush);
        this.host = propertyResolver.getStringProperty("host", this.host);
        this.port = propertyResolver.getIntegerProperty("port", this.port);
        this.poolSize = propertyResolver.getIntegerProperty("poolSize", this.poolSize);
        this.keepAlive = propertyResolver.getBooleanProperty("keepAlive", this.keepAlive);
        this.pipeline = propertyResolver.getBooleanProperty("pipeline", this.pipeline);
        this.timeOutInMilliseconds = propertyResolver.getIntegerProperty("timeOutInMilliseconds", this.timeOutInMilliseconds);
        this.flushInterval = propertyResolver.getIntegerProperty("flushInterval", this.flushInterval);
        this.soLinger = propertyResolver.getIntegerProperty("soLinger", this.soLinger);
        this.ssl = propertyResolver.getBooleanProperty("ssl", this.ssl);
        this.verifyHost = propertyResolver.getBooleanProperty("verifyHost", this.verifyHost);
        this.trustAll = propertyResolver.getBooleanProperty("trustAll", this.trustAll);
        this.tryUseCompression = propertyResolver.getBooleanProperty("tryUseCompression", this.tryUseCompression);
        this.tcpNoDelay = propertyResolver.getBooleanProperty("tcpNoDelay", this.tcpNoDelay);
        this.trustStorePath = propertyResolver.getStringProperty("trustStorePath", this.trustStorePath);
        this.trustStorePassword = propertyResolver.getStringProperty("trustStorePassword", this.trustStorePassword);
    }

    public HttpClientBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(QBIT_HTTP_CLIENT_BUILDER));
    }

    public HttpClientBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(QBIT_HTTP_CLIENT_BUILDER, properties));
    }

    public static HttpClientBuilder httpClientBuilder() {
        return new HttpClientBuilder();
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public HttpClientBuilder setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpClientBuilder setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean isPipeline() {
        return this.pipeline;
    }

    public HttpClientBuilder setPipeline(boolean pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public HttpClientBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public HttpClientBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public HttpClientBuilder setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    public int getTimeOutInMilliseconds() {
        return this.timeOutInMilliseconds;
    }

    public HttpClientBuilder setTimeOutInMilliseconds(int timeOutInMilliseconds) {
        this.timeOutInMilliseconds = timeOutInMilliseconds;
        return this;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public HttpClientBuilder setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public HttpClientBuilder setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public HttpClientBuilder setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public HttpClientBuilder setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public int getMaxWebSocketFrameSize() {
        return this.maxWebSocketFrameSize;
    }

    public HttpClientBuilder setMaxWebSocketFrameSize(int maxWebSocketFrameSize) {
        this.maxWebSocketFrameSize = maxWebSocketFrameSize;
        return this;
    }

    public boolean isTryUseCompression() {
        return this.tryUseCompression;
    }

    public HttpClientBuilder setTryUseCompression(boolean tryUseCompression) {
        this.tryUseCompression = tryUseCompression;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public HttpClientBuilder setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public HttpClientBuilder setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public HttpClient build() {
        HttpClient httpClient = QBit.factory().createHttpClient(this.getHost(), this.getPort(), this.getTimeOutInMilliseconds(), this.getPoolSize(), this.isAutoFlush(), this.getFlushInterval(), this.isKeepAlive(), this.isPipeline(), this.isSsl(), this.isVerifyHost(), this.isTrustAll(), this.getMaxWebSocketFrameSize(), this.isTryUseCompression(), this.getTrustStorePath(), this.getTrustStorePassword(), this.isTcpNoDelay(), this.getSoLinger());
        return httpClient;
    }

    public HttpClient buildAndStart() {
        HttpClient client = this.build();
        client.start();
        return client;
    }
}

