/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.request;

import io.advantageous.qbit.http.request.HttpResponseReceiver;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.util.MultiMap;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class HttpRequest
implements Request<Object> {
    private final String uri;
    private final String remoteAddress;
    private final MultiMap<String, String> params;
    private final MultiMap<String, String> headers;
    private final byte[] body;
    private final String contentType;
    private final String method;
    private final HttpResponseReceiver receiver;
    private final long messageId;
    private final long timestamp;
    private volatile boolean handled;

    public HttpRequest(long id, String uri, String method, MultiMap<String, String> params, MultiMap<String, String> headers, byte[] body, String remoteAddress, String contentType, HttpResponseReceiver response, long timestamp) {
        this.uri = uri;
        this.messageId = id;
        this.params = params;
        this.body = body;
        this.method = method;
        this.contentType = contentType;
        this.receiver = response;
        this.remoteAddress = remoteAddress;
        this.headers = headers;
        this.timestamp = timestamp;
    }

    @Override
    public String address() {
        return this.uri;
    }

    @Override
    public String returnAddress() {
        return this.remoteAddress;
    }

    @Override
    public MultiMap<String, String> params() {
        return this.params;
    }

    @Override
    public MultiMap<String, String> headers() {
        return this.headers;
    }

    @Override
    public boolean hasParams() {
        return false;
    }

    @Override
    public boolean hasHeaders() {
        return false;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public synchronized boolean isHandled() {
        return this.handled;
    }

    @Override
    public synchronized void handled() {
        this.handled = true;
    }

    @Override
    public long id() {
        return this.messageId;
    }

    @Override
    public Object body() {
        return this.body;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public MultiMap<String, String> getParams() {
        return this.params;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        return new String(this.body, StandardCharsets.UTF_8);
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpResponseReceiver<Object> getReceiver() {
        return this.receiver;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest request = (HttpRequest)o;
        if (this.messageId != request.messageId) {
            return false;
        }
        if (this.timestamp != request.timestamp) {
            return false;
        }
        if (!this.method.equals(request.method)) {
            return false;
        }
        return this.uri.equals(request.uri);
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String getContentType() {
        if (this.contentType == null) {
            return this.headers != MultiMap.EMPTY ? (String)this.headers.get("Content-Type") : "";
        }
        return this.contentType;
    }

    public boolean isJson() {
        return "application/json".equals(this.contentType);
    }

    public String toString() {
        return "HttpRequest{uri='" + this.uri + '\'' + ", remoteAddress='" + this.remoteAddress + '\'' + ", params=" + this.params + ", headers=" + this.headers + ", body=" + Arrays.toString(this.body) + ", contentType='" + this.contentType + '\'' + ", method='" + this.method + '\'' + ", receiver=" + this.receiver + ", messageId=" + this.messageId + ", timestamp=" + this.timestamp + ", handled=" + this.handled + '}';
    }
}

