/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.request;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.primitive.ByteBuf;
import io.advantageous.qbit.http.request.HttpBinaryReceiver;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.http.request.HttpResponseReceiver;
import io.advantageous.qbit.http.request.HttpTextReceiver;
import io.advantageous.qbit.util.GzipUtils;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.MultiMapImpl;
import io.advantageous.qbit.util.Timer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class HttpRequestBuilder {
    public static final byte[] EMPTY_STRING = "".getBytes(StandardCharsets.UTF_8);
    private static final ThreadLocal<RequestIdGenerator> idGen = new ThreadLocal<RequestIdGenerator>(){

        @Override
        protected RequestIdGenerator initialValue() {
            return new RequestIdGenerator();
        }
    };
    private String uri = "/";
    private long id;
    private long timestamp;
    private String contentType;
    private String remoteAddress;
    private MultiMap<String, String> params;
    private MultiMap<String, String> headers;
    private byte[] body;
    private String method = "GET";
    private Consumer<Exception> errorHandler;
    private HttpResponseReceiver receiver = (code, mimeType, body1) -> {};

    public static HttpRequestBuilder httpRequestBuilder() {
        return new HttpRequestBuilder();
    }

    public Consumer<Exception> getErrorHandler() {
        return this.errorHandler;
    }

    public HttpRequestBuilder setErrorHandler(Consumer<Exception> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public HttpRequestBuilder setMethodPost() {
        this.method = "POST";
        return this;
    }

    public HttpRequestBuilder setMethodOptions() {
        this.method = "OPTIONS";
        return this;
    }

    public HttpRequestBuilder setMethodGet() {
        this.method = "GET";
        return this;
    }

    public HttpRequestBuilder setMethodPut() {
        this.method = "PUT";
        return this;
    }

    public HttpRequestBuilder setMethodDelete() {
        this.method = "DELETE";
        return this;
    }

    public long getId() {
        return this.id;
    }

    public HttpRequestBuilder setId(long id) {
        this.id = id;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public HttpRequestBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpRequestBuilder setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public HttpRequestBuilder setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public MultiMap<String, String> getParams() {
        return this.params == null ? MultiMap.EMPTY : this.params;
    }

    public HttpRequestBuilder setParams(MultiMap<String, String> params) {
        this.params = params;
        return this;
    }

    public String getBody() {
        return new String(this.body, StandardCharsets.UTF_8);
    }

    public HttpRequestBuilder setBody(String body) {
        this.setBodyBytes(body.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpRequestBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpResponseReceiver getReceiver() {
        return this.receiver;
    }

    public <T> HttpRequestBuilder receiver(HttpResponseReceiver<T> receiver) {
        this.receiver = receiver;
        return this;
    }

    public HttpRequestBuilder setTextReceiver(HttpTextReceiver response) {
        this.receiver = response;
        return this;
    }

    public HttpRequestBuilder setResponse(HttpResponseReceiver response) {
        this.receiver = response;
        return this;
    }

    public HttpRequestBuilder setBinaryReceiver(HttpBinaryReceiver response) {
        this.receiver = response;
        return this;
    }

    public HttpRequest buildClientRequest() {
        String newURI = this.uri;
        if (this.params != null && this.params.size() > 1) {
            String paramString = this.paramString();
            switch (this.method) {
                case "GET": 
                case "OPTION": 
                case "HEAD": 
                case "DELETE": {
                    newURI = Str.add((String[])new String[]{this.uri, "?", paramString});
                    break;
                }
                case "POST": 
                case "PUT": {
                    this.setBodyBytes(paramString.getBytes(StandardCharsets.UTF_8));
                    this.setContentType("application/x-www-form-urlencoded");
                }
            }
        }
        HttpResponseReceiver httpResponse = this.buildHttpResponseReceiver();
        if (this.id == 0L) {
            this.id = HttpRequestBuilder.idGen.get().inc();
        }
        if (this.timestamp == 0L) {
            this.timestamp = Timer.timer().now();
        }
        if (this.contentType != null) {
            this.addHeader("Content-Type", this.contentType);
        }
        return new HttpRequest(this.getId(), newURI, this.getMethod(), this.getParams(), this.getHeaders(), this.getBodyBytes() != null ? this.getBodyBytes() : EMPTY_STRING, this.getRemoteAddress(), this.getContentType(), httpResponse, this.getTimestamp());
    }

    public HttpRequest build() {
        String newURI = this.uri;
        HttpResponseReceiver httpResponse = this.buildHttpResponseReceiver();
        if (this.id == 0L) {
            this.id = HttpRequestBuilder.idGen.get().inc();
        }
        if (this.timestamp == 0L) {
            this.timestamp = Timer.timer().now();
        }
        if (this.contentType != null) {
            this.addHeader("Content-Type", this.contentType);
        }
        HttpRequest request = new HttpRequest(this.getId(), newURI, this.getMethod(), this.getParams(), this.getHeaders(), this.getBodyBytes() != null ? this.getBodyBytes() : new byte[]{}, this.getRemoteAddress(), this.getContentType(), httpResponse, this.getTimestamp());
        return request;
    }

    private HttpResponseReceiver buildHttpResponseReceiver() {
        HttpResponseReceiver httpResponse = this.getReceiver();
        if (this.errorHandler != null) {
            final HttpResponseReceiver innerHttpResponse = this.getReceiver();
            final Consumer<Exception> innerErrorHandler = this.getErrorHandler();
            httpResponse = new HttpResponseReceiver(){

                public void response(int code, String contentType, Object body) {
                    innerHttpResponse.response(code, contentType, body);
                }

                @Override
                public boolean isText() {
                    return innerHttpResponse.isText();
                }

                public void response(int code, String contentType, Object body, MultiMap headers) {
                    innerHttpResponse.response(code, contentType, body, headers);
                }

                @Override
                public Consumer<Exception> errorHandler() {
                    return innerErrorHandler;
                }
            };
        }
        return httpResponse;
    }

    public String getContentType() {
        return this.contentType;
    }

    public HttpRequestBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers == null ? MultiMap.EMPTY : this.headers;
    }

    public HttpRequestBuilder setHeaders(MultiMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequestBuilder setHeaders(Map<String, String> headerMap) {
        headerMap.entrySet().forEach(entry -> this.addHeader((String)entry.getKey(), (String)entry.getValue()));
        return this;
    }

    public HttpRequestBuilder setJsonContentType() {
        this.contentType = "application/json; charset=\"UTF-8\"";
        return this;
    }

    public HttpRequestBuilder setJsonBodyForPost(String body) {
        this.setJsonContentType();
        this.setBody(body);
        this.setMethod("POST");
        return this;
    }

    public HttpRequestBuilder setJsonBodyForPut(String body) {
        this.setJsonContentType();
        this.setBody(body);
        this.setMethod("PUT");
        return this;
    }

    public HttpRequestBuilder addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new MultiMapImpl<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public HttpRequestBuilder addParam(String name, String value) {
        if (this.params == null) {
            this.params = new MultiMapImpl<String, String>();
        }
        this.params.put(name, value);
        return this;
    }

    public String paramString() {
        String paramString = "";
        if (this.params != null) {
            ByteBuf buf = ByteBuf.create((int)244);
            Set keys = this.params.keySet();
            int index = 0;
            for (String key : keys) {
                Iterable<String> paramsAtKey = this.params.getAll(key);
                for (String value : paramsAtKey) {
                    if (index > 0) {
                        buf.addByte(38);
                    }
                    buf.addUrlEncoded(key);
                    buf.addByte(61);
                    if (!(value instanceof byte[])) {
                        buf.addUrlEncoded(value.toString());
                    } else {
                        buf.addUrlEncodedByteArray((byte[])value);
                    }
                    ++index;
                }
            }
            paramString = buf.toString();
        }
        this.params = MultiMap.empty();
        return paramString;
    }

    public HttpRequestBuilder setFormPutAndCreateFormBody() {
        if (this.params.size() == 0) {
            throw new IllegalStateException("Form must have params, you must add the params before you call this method");
        }
        String paramString = this.paramString();
        this.setContentType("application/x-www-form-urlencoded");
        this.setMethod("PUT");
        this.setBodyBytes(paramString.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public HttpRequestBuilder setFormPostAndCreateFormBody() {
        if (this.getParams().size() == 0) {
            throw new IllegalStateException("Form must have params, you must add the params before you call this method");
        }
        String paramString = this.paramString();
        this.setContentType("application/x-www-form-urlencoded");
        this.setMethod("POST");
        this.setBodyBytes(paramString.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public byte[] getBodyBytes() {
        return this.body;
    }

    public HttpRequestBuilder setBodyBytes(byte[] bodyBytes) {
        this.body = bodyBytes;
        return this;
    }

    public HttpRequestBuilder setJsonBodyForPostGzip(String jsonBodyForPostGzip) {
        try {
            this.setBodyBytes(GzipUtils.encode(jsonBodyForPostGzip));
            this.addHeader("Accept-Encoding", "gzip, deflate");
            this.addHeader("Content-Encoding", "gzip");
            this.setJsonContentType();
            this.setMethodPost();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public HttpRequestBuilder setJsonBodyForPutGzip(String jsonBodyForPostGzip) {
        try {
            this.setBodyBytes(GzipUtils.encode(jsonBodyForPostGzip));
            this.addHeader("Accept-Encoding", "gzip, deflate");
            this.addHeader("Content-Encoding", "gzip");
            this.setJsonContentType();
            this.setMethodPut();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public HttpRequestBuilder initFormIfNeeded() {
        if (this.getParams().size() == 0) {
            return this;
        }
        if (this.getMethod().equals("POST") || this.getMethod().equals("PUT")) {
            this.setContentType("application/x-www-form-urlencoded");
            String paramString = this.paramString();
            this.setBodyBytes(paramString.getBytes(StandardCharsets.UTF_8));
        }
        return this;
    }

    public HttpRequestBuilder copyRequest(HttpRequest request) {
        this.setContentType(request.getContentType());
        this.setMethod(request.getMethod());
        if (request.getHeaders().size() > 0) {
            MultiMap<String, String> headers = this.getHeaders();
            request.getHeaders().forEach(entry -> ((Collection)entry.getValue()).forEach(value -> headers.add((String)entry.getKey(), (String)value)));
        }
        if (request.getParams().size() > 0) {
            MultiMap<String, String> params = this.getParams();
            request.getParams().forEach(entry -> ((Collection)entry.getValue()).forEach(value -> params.add((String)entry.getKey(), (String)value)));
        }
        byte[] body = request.getBody();
        this.setBodyBytes(body);
        this.setParams(request.getParams());
        this.setUri(request.getUri());
        return this;
    }

    private static class RequestIdGenerator {
        private long value;

        private RequestIdGenerator() {
        }

        private long inc() {
            return this.value++;
        }
    }
}

