/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.request;

import io.advantageous.qbit.http.request.HttpBinaryResponse;
import io.advantageous.qbit.http.request.HttpResponse;
import io.advantageous.qbit.http.request.HttpTextResponse;
import io.advantageous.qbit.http.request.impl.HttpBinaryResponseImpl;
import io.advantageous.qbit.http.request.impl.HttpTextResponseImpl;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.MultiMapImpl;
import java.nio.charset.StandardCharsets;

public class HttpResponseBuilder {
    private int code;
    private String contentType;
    private Object body;
    private MultiMap<String, String> headers;

    public static HttpResponseBuilder httpResponseBuilder() {
        return new HttpResponseBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public HttpResponseBuilder setCode(int code) {
        this.code = code;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public HttpResponseBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public HttpResponseBuilder setJsonBody(String json) {
        this.setContentType("application/json");
        this.setBody(json);
        return this;
    }

    public HttpResponseBuilder setJsonBodyCodeOk(String json) {
        this.setCode(200);
        this.setContentType("application/json");
        this.setBody(json);
        return this;
    }

    public HttpResponseBuilder setJsonBodyError(String json) {
        this.setCode(500);
        this.setContentType("application/json");
        this.setBody(json);
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public HttpResponseBuilder setBody(Object body) {
        this.body = body;
        return this;
    }

    public MultiMap<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new MultiMapImpl<String, String>();
        }
        return this.headers;
    }

    public HttpResponseBuilder addHeader(String name, String value) {
        this.getHeaders().put(name, value);
        return this;
    }

    public HttpResponseBuilder setHeaders(MultiMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpResponse<?> build() {
        if (this.getBody() instanceof byte[]) {
            return new HttpBinaryResponseImpl(this.getCode(), this.getContentType(), (byte[])this.getBody(), this.headers);
        }
        return new HttpTextResponseImpl(this.getCode(), this.getContentType(), this.getBody().toString(), this.headers);
    }

    public HttpTextResponse buildTextResponse() {
        if (this.getBody() instanceof byte[]) {
            return new HttpTextResponseImpl(this.getCode(), this.getContentType(), new String((byte[])this.getBody(), StandardCharsets.UTF_8), this.headers);
        }
        return new HttpTextResponseImpl(this.getCode(), this.getContentType(), this.getBody().toString(), this.headers);
    }

    public HttpBinaryResponse buildBinaryResponse() {
        if (this.getBody() instanceof byte[]) {
            return new HttpBinaryResponseImpl(this.getCode(), this.getContentType(), (byte[])this.getBody(), this.headers);
        }
        return new HttpBinaryResponseImpl(this.getCode(), this.getContentType(), this.getBody().toString().getBytes(StandardCharsets.UTF_8), this.headers);
    }
}

