/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.request;

import io.advantageous.qbit.http.request.HttpTextResponse;
import io.advantageous.qbit.util.MultiMap;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public interface HttpResponseReceiver<T> {
    default public boolean isText() {
        return true;
    }

    public void response(int var1, String var2, T var3);

    default public void response(int code, String contentType, T body, MultiMap<String, String> headers) {
        this.response(code, contentType, body);
    }

    default public Consumer<Exception> errorHandler() {
        return exception -> LoggerFactory.getLogger(HttpTextResponse.class).error(exception.getMessage(), (Throwable)exception);
    }

    default public void respondOK(String json) {
        this.respond(200, json);
    }

    default public void error(String json) {
        this.respond(500, json);
    }

    default public void errorWithCode(String json, int code) {
        this.respond(code, json);
    }

    default public void timeout() {
        this.respond(408, "\"Timeout\"");
    }

    default public void timeoutWithMessage(String json) {
        this.respond(408, "\"Timeout\"");
    }

    default public void respond(int code, String json) {
        if (!this.isText()) {
            this.response(code, "application/json", json.getBytes(StandardCharsets.UTF_8));
        } else {
            this.response(code, "application/json", json);
        }
    }

    default public void notFound() {
        this.respond(404, "\"not found\"");
    }
}

