/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.request.impl;

import io.advantageous.qbit.http.request.HttpBinaryResponse;
import io.advantageous.qbit.http.request.HttpResponse;
import io.advantageous.qbit.http.request.HttpResponseCreator;
import io.advantageous.qbit.http.request.HttpResponseDecorator;
import io.advantageous.qbit.http.request.HttpTextResponse;
import io.advantageous.qbit.util.MultiMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class HttpResponseCreatorDefault
implements HttpResponseCreator {
    @Override
    public HttpResponse<?> createResponse(CopyOnWriteArrayList<HttpResponseDecorator> decorators, String requestPath, int code, String contentType, Object payload, MultiMap<String, String> responseHeaders, MultiMap<String, String> requestHeaders, MultiMap<String, String> requestParams) {
        if (decorators.size() == 0) {
            return null;
        }
        if (payload instanceof byte[]) {
            return this.createBinaryResponse(decorators, requestPath, code, contentType, (byte[])payload, responseHeaders, requestHeaders, requestParams);
        }
        return this.createTextResponse(decorators, requestPath, code, contentType, payload.toString(), responseHeaders, requestHeaders, requestParams);
    }

    private HttpTextResponse createTextResponse(CopyOnWriteArrayList<HttpResponseDecorator> decorators, String requestPath, int code, String contentType, String payload, MultiMap<String, String> responseHeaders, MultiMap<String, String> requestHeaders, MultiMap<String, String> requestParams) {
        HttpTextResponse httpTextResponse = null;
        if (decorators.size() >= 0) {
            HttpTextResponse[] holder = new HttpTextResponse[1];
            for (HttpResponseDecorator decorator : decorators) {
                if (!decorator.decorateTextResponse(holder, requestPath, code, contentType, payload, responseHeaders, requestHeaders, requestParams)) continue;
                httpTextResponse = holder[0];
                break;
            }
        }
        return httpTextResponse;
    }

    private HttpBinaryResponse createBinaryResponse(CopyOnWriteArrayList<HttpResponseDecorator> decorators, String requestPath, int code, String contentType, byte[] payload, MultiMap<String, String> responseHeaders, MultiMap<String, String> requestHeaders, MultiMap<String, String> requestParams) {
        HttpBinaryResponse httpResponse = null;
        if (decorators.size() >= 0) {
            HttpBinaryResponse[] holder = new HttpBinaryResponse[1];
            for (HttpResponseDecorator decorator : decorators) {
                if (!decorator.decorateBinaryResponse(holder, requestPath, code, contentType, payload, responseHeaders, requestHeaders, requestParams)) continue;
                httpResponse = holder[0];
                break;
            }
        }
        return httpResponse;
    }
}

