/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.server;

import io.advantageous.qbit.Factory;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.http.config.HttpServerConfig;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.http.request.HttpResponseCreator;
import io.advantageous.qbit.http.request.HttpResponseDecorator;
import io.advantageous.qbit.http.request.impl.HttpResponseCreatorDefault;
import io.advantageous.qbit.http.server.HttpServer;
import io.advantageous.qbit.http.server.RequestContinuePredicate;
import io.advantageous.qbit.service.discovery.ServiceDiscovery;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.system.QBitSystemManager;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class HttpServerBuilder {
    private HttpServerConfig httpServerConfig;
    private QBitSystemManager qBitSystemManager;
    private ServiceDiscovery serviceDiscovery;
    private HealthServiceAsync healthServiceAsync;
    private Factory factory;
    private String endpointName;
    private int serviceDiscoveryTtl = 60;
    private TimeUnit serviceDiscoveryTtlTimeUnit = TimeUnit.SECONDS;
    private RequestContinuePredicate requestContinuePredicate = null;
    private CopyOnWriteArrayList<HttpResponseDecorator> responseDecorators = new CopyOnWriteArrayList();
    private HttpResponseCreator httpResponseCreator = new HttpResponseCreatorDefault();

    public CopyOnWriteArrayList<HttpResponseDecorator> getResponseDecorators() {
        return this.responseDecorators;
    }

    public HttpServerBuilder setResponseDecorators(CopyOnWriteArrayList<HttpResponseDecorator> decorators) {
        this.responseDecorators = decorators;
        return this;
    }

    public HttpServerBuilder addResponseDecorator(HttpResponseDecorator decorator) {
        this.responseDecorators.add(decorator);
        return this;
    }

    public HttpResponseCreator getHttpResponseCreator() {
        return this.httpResponseCreator;
    }

    public HttpServerBuilder setHttpResponseCreator(HttpResponseCreator httpResponseCreator) {
        this.httpResponseCreator = httpResponseCreator;
        return null;
    }

    public RequestContinuePredicate getRequestContinuePredicate() {
        if (this.requestContinuePredicate == null) {
            this.requestContinuePredicate = new RequestContinuePredicate();
        }
        return this.requestContinuePredicate;
    }

    public HttpServerBuilder setRequestContinuePredicate(RequestContinuePredicate requestContinuePredicate) {
        this.requestContinuePredicate = requestContinuePredicate;
        return this;
    }

    public HttpServerBuilder addShouldContinueHttpRequestPredicate(Predicate<HttpRequest> predicate) {
        this.getRequestContinuePredicate().add(predicate);
        return this;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public HttpServerBuilder setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
        return this;
    }

    public HealthServiceAsync getHealthServiceAsync() {
        return this.healthServiceAsync;
    }

    public HttpServerBuilder setHealthServiceAsync(HealthServiceAsync healthServiceAsync) {
        this.healthServiceAsync = healthServiceAsync;
        return this;
    }

    public Factory getFactory() {
        if (this.factory == null) {
            this.factory = QBit.factory();
        }
        return this.factory;
    }

    public HttpServerBuilder setFactory(Factory factory) {
        this.factory = factory;
        return this;
    }

    public static HttpServerBuilder httpServerBuilder() {
        return new HttpServerBuilder();
    }

    public QBitSystemManager getSystemManager() {
        return this.qBitSystemManager;
    }

    public HttpServerBuilder setSystemManager(QBitSystemManager qBitSystemManager) {
        this.qBitSystemManager = qBitSystemManager;
        return this;
    }

    public HttpServerConfig getHttpServerConfig() {
        if (this.httpServerConfig == null) {
            this.httpServerConfig = new HttpServerConfig();
            this.httpServerConfig.setFlushInterval(50);
        }
        return this.httpServerConfig;
    }

    public HttpServerBuilder setHttpServerConfig(HttpServerConfig httpServerConfig) {
        this.httpServerConfig = httpServerConfig;
        return this;
    }

    public int getWorkers() {
        return this.getHttpServerConfig().getWorkers();
    }

    public HttpServerBuilder setWorkers(int workers) {
        this.getHttpServerConfig().setWorkers(workers);
        return this;
    }

    public boolean isPipeline() {
        return this.getHttpServerConfig().isPipeline();
    }

    public HttpServerBuilder setPipeline(boolean pipeline) {
        this.getHttpServerConfig().setPipeline(pipeline);
        return this;
    }

    public String getHost() {
        return this.getHttpServerConfig().getHost();
    }

    public HttpServerBuilder setHost(String host) {
        this.getHttpServerConfig().setHost(host);
        return this;
    }

    public int getPort() {
        return this.getHttpServerConfig().getPort();
    }

    public HttpServerBuilder setPort(int port) {
        this.getHttpServerConfig().setPort(port);
        return this;
    }

    public int getFlushInterval() {
        return this.getHttpServerConfig().getFlushInterval();
    }

    public HttpServerBuilder setFlushInterval(int flushInterval) {
        this.getHttpServerConfig().setFlushInterval(flushInterval);
        return this;
    }

    public HttpServerConfig getConfig() {
        if (this.httpServerConfig == null) {
            this.httpServerConfig = new HttpServerConfig();
        }
        return this.httpServerConfig;
    }

    public HttpServerBuilder setConfig(HttpServerConfig config) {
        this.httpServerConfig = config;
        return this;
    }

    public HttpServerBuilder withConfig(Consumer<HttpServerConfig> config) {
        config.accept(this.httpServerConfig);
        return this;
    }

    public HttpServer build() {
        HttpServer httpServer = this.getFactory().createHttpServer(this.getConfig(), this.getEndpointName(), this.getSystemManager(), this.getServiceDiscovery(), this.getHealthServiceAsync(), this.getServiceDiscoveryTtl(), this.getServiceDiscoveryTtlTimeUnit(), this.getResponseDecorators(), this.getHttpResponseCreator());
        if (this.requestContinuePredicate != null) {
            httpServer.setShouldContinueHttpRequest(this.requestContinuePredicate);
        }
        if (this.qBitSystemManager != null) {
            this.qBitSystemManager.registerServer(httpServer);
        }
        return httpServer;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public HttpServerBuilder setEndpointName(String endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    public int getServiceDiscoveryTtl() {
        return this.serviceDiscoveryTtl;
    }

    public HttpServerBuilder setServiceDiscoveryTtl(int serviceDiscoveryTtl) {
        this.serviceDiscoveryTtl = serviceDiscoveryTtl;
        return this;
    }

    public TimeUnit getServiceDiscoveryTtlTimeUnit() {
        return this.serviceDiscoveryTtlTimeUnit;
    }

    public HttpServerBuilder setServiceDiscoveryTtlTimeUnit(TimeUnit serviceDiscoveryTtlTimeUnit) {
        this.serviceDiscoveryTtlTimeUnit = serviceDiscoveryTtlTimeUnit;
        return this;
    }
}

