/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.server.impl;

import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.concurrent.ExecutorContext;
import io.advantageous.qbit.concurrent.ScheduledExecutorBuilder;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.http.request.HttpResponseCreator;
import io.advantageous.qbit.http.request.HttpResponseDecorator;
import io.advantageous.qbit.http.request.impl.HttpResponseCreatorDefault;
import io.advantageous.qbit.http.server.HttpServer;
import io.advantageous.qbit.http.server.websocket.WebSocketMessage;
import io.advantageous.qbit.http.server.websocket.WebSocketMessageBuilder;
import io.advantageous.qbit.http.websocket.WebSocket;
import io.advantageous.qbit.http.websocket.WebSocketSender;
import io.advantageous.qbit.service.ServiceProxyUtils;
import io.advantageous.qbit.service.discovery.EndpointDefinition;
import io.advantageous.qbit.service.discovery.ServiceDiscovery;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.health.HealthStatus;
import io.advantageous.qbit.system.QBitSystemManager;
import io.advantageous.qbit.util.Timer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpServer
implements HttpServer {
    private final Logger logger = LoggerFactory.getLogger(SimpleHttpServer.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final QBitSystemManager systemManager;
    private final int flushInterval;
    private final ServiceDiscovery serviceDiscovery;
    private final HealthServiceAsync healthServiceAsync;
    private final String name;
    private final int port;
    private final long checkInEveryMiliDuration;
    private final CopyOnWriteArrayList<HttpResponseDecorator> decorators;
    private final HttpResponseCreator httpResponseCreator;
    private Consumer<WebSocketMessage> webSocketMessageConsumer;
    private Consumer<WebSocketMessage> webSocketCloseMessageConsumer;
    private Consumer<HttpRequest> httpRequestConsumer;
    private Consumer<Void> requestIdleConsumer;
    private Consumer<WebSocket> webSocketConsumer;
    private Consumer<Void> webSocketIdleConsumer;
    private Predicate<HttpRequest> shouldContinueHttpRequest;
    private ExecutorContext executorContext;
    private Predicate<WebSocket> shouldContinueWebSocket;
    private final EndpointDefinition endpointDefinition;
    final AtomicLong lastCheckIn;
    final AtomicBoolean ok;

    public SimpleHttpServer(String endpointName, QBitSystemManager systemManager, int flushInterval, int port, ServiceDiscovery serviceDiscovery, HealthServiceAsync healthServiceAsync, int serviceDiscoveryTtl, TimeUnit serviceDiscoveryTtlTimeUnit, CopyOnWriteArrayList<HttpResponseDecorator> decorators, HttpResponseCreator httpResponseCreator) {
        this.webSocketMessageConsumer = webSocketMessage -> {};
        this.webSocketCloseMessageConsumer = webSocketMessage -> {};
        this.httpRequestConsumer = request -> {};
        this.requestIdleConsumer = aVoid -> {};
        this.webSocketConsumer = this::defaultWebSocketHandler;
        this.webSocketIdleConsumer = aVoid -> {};
        this.shouldContinueHttpRequest = request -> true;
        this.shouldContinueWebSocket = webSocket -> true;
        this.lastCheckIn = new AtomicLong(Timer.clockTime());
        this.ok = new AtomicBoolean(true);
        this.decorators = decorators;
        this.httpResponseCreator = httpResponseCreator;
        this.name = endpointName == null ? "HTTP_SERVER_" + port : endpointName;
        this.port = port;
        this.systemManager = systemManager;
        this.flushInterval = flushInterval;
        this.serviceDiscovery = serviceDiscovery;
        this.healthServiceAsync = healthServiceAsync;
        this.endpointDefinition = this.createEndpointDefinition(serviceDiscoveryTtl, serviceDiscoveryTtlTimeUnit);
        this.checkInEveryMiliDuration = serviceDiscoveryTtlTimeUnit.toMillis(serviceDiscoveryTtl) / 3L;
    }

    EndpointDefinition createEndpointDefinition(int serviceDiscoveryTtl, TimeUnit serviceDiscoveryTtlTimeUnit) {
        EndpointDefinition endpointDefinition;
        if (this.serviceDiscovery != null) {
            endpointDefinition = this.serviceDiscovery.registerWithTTL(this.name, this.port, (int)serviceDiscoveryTtlTimeUnit.toSeconds(serviceDiscoveryTtl));
            this.serviceDiscovery.checkInOk(endpointDefinition.getId());
        } else {
            endpointDefinition = null;
        }
        return endpointDefinition;
    }

    public SimpleHttpServer() {
        this.webSocketMessageConsumer = webSocketMessage -> {};
        this.webSocketCloseMessageConsumer = webSocketMessage -> {};
        this.httpRequestConsumer = request -> {};
        this.requestIdleConsumer = aVoid -> {};
        this.webSocketConsumer = this::defaultWebSocketHandler;
        this.webSocketIdleConsumer = aVoid -> {};
        this.shouldContinueHttpRequest = request -> true;
        this.shouldContinueWebSocket = webSocket -> true;
        this.lastCheckIn = new AtomicLong(Timer.clockTime());
        this.ok = new AtomicBoolean(true);
        this.port = 8080;
        this.name = "HTTP_SERVER";
        this.systemManager = null;
        this.flushInterval = 1;
        this.serviceDiscovery = null;
        this.healthServiceAsync = null;
        this.endpointDefinition = null;
        this.checkInEveryMiliDuration = 100000L;
        this.decorators = new CopyOnWriteArrayList();
        this.httpResponseCreator = new HttpResponseCreatorDefault();
    }

    public void handleRequest(HttpRequest request) {
        if (this.debug) {
            System.out.println("HttpServer::handleRequest " + request);
            this.logger.debug("HttpServer::handleRequest" + request);
        }
        if (this.shouldContinueHttpRequest.test(request)) {
            this.httpRequestConsumer.accept(request);
        }
    }

    public void handleWebSocketMessage(WebSocketMessage webSocketMessage) {
        this.webSocketMessageConsumer.accept(webSocketMessage);
    }

    public void handleWebSocketClosedMessage(WebSocketMessage webSocketMessage) {
        this.webSocketCloseMessageConsumer.accept(webSocketMessage);
    }

    @Override
    public void setShouldContinueHttpRequest(Predicate<HttpRequest> predicate) {
        this.shouldContinueHttpRequest = predicate;
    }

    @Override
    public void setShouldContinueWebSocket(Predicate<WebSocket> predicate) {
        this.shouldContinueWebSocket = predicate;
    }

    @Override
    public void setWebSocketMessageConsumer(Consumer<WebSocketMessage> webSocketMessageConsumer) {
        this.webSocketMessageConsumer = webSocketMessageConsumer;
    }

    @Override
    public void setWebSocketCloseConsumer(Consumer<WebSocketMessage> webSocketCloseMessageConsumer) {
        this.webSocketCloseMessageConsumer = webSocketCloseMessageConsumer;
    }

    @Override
    public void setHttpRequestConsumer(Consumer<HttpRequest> httpRequestConsumer) {
        this.httpRequestConsumer = httpRequestConsumer;
    }

    @Override
    public void setHttpRequestsIdleConsumer(Consumer<Void> idleConsumer) {
        this.requestIdleConsumer = idleConsumer;
    }

    @Override
    public void setWebSocketIdleConsume(Consumer<Void> idleConsumer) {
        this.webSocketIdleConsumer = idleConsumer;
    }

    @Override
    public void start() {
        if (this.debug) {
            this.logger.debug("HttpServer Started");
        }
        this.startPeriodicFlush();
    }

    private void startPeriodicFlush() {
        if (this.executorContext != null) {
            throw new IllegalStateException("Can't call startClient twice");
        }
        this.executorContext = ScheduledExecutorBuilder.scheduledExecutorBuilder().setThreadName("HttpServer").setInitialDelay(this.flushInterval).setPeriod(this.flushInterval).setDescription("HttpServer Periodic Flush").setRunnable(() -> {
            this.handleRequestQueueIdle();
            this.handleWebSocketQueueIdle();
        }).build();
        this.executorContext.start();
    }

    @Override
    public void stop() {
        if (this.systemManager != null) {
            this.systemManager.serviceShutDown();
        }
        if (this.debug) {
            this.logger.debug("HttpServer Stopped");
        }
        if (this.executorContext != null) {
            this.executorContext.stop();
        }
    }

    public void handleWebSocketQueueIdle() {
        this.webSocketIdleConsumer.accept(null);
    }

    public void handleRequestQueueIdle() {
        if (this.serviceDiscovery != null) {
            this.handleCheckIn();
        }
        this.requestIdleConsumer.accept(null);
    }

    public void handleCheckIn() {
        if (this.healthServiceAsync == null) {
            if (Timer.clockTime() - this.lastCheckIn.get() > this.checkInEveryMiliDuration) {
                this.lastCheckIn.set(Timer.clockTime());
                this.serviceDiscovery.checkInOk(this.endpointDefinition.getId());
            }
        } else if (Timer.clockTime() - this.lastCheckIn.get() > this.checkInEveryMiliDuration) {
            this.lastCheckIn.set(Timer.clockTime());
            this.healthServiceAsync.ok(this.ok::set);
            ServiceProxyUtils.flushServiceProxy(this.healthServiceAsync);
            if (this.ok.get()) {
                this.serviceDiscovery.checkInOk(this.endpointDefinition.getId());
            } else {
                this.serviceDiscovery.checkIn(this.endpointDefinition.getId(), HealthStatus.FAIL);
            }
            ServiceProxyUtils.flushServiceProxy(this.serviceDiscovery);
        }
    }

    public void handleOpenWebSocket(WebSocket webSocket) {
        if (this.shouldContinueWebSocket.test(webSocket)) {
            this.webSocketConsumer.accept(webSocket);
        }
    }

    private void defaultWebSocketHandler(final WebSocket webSocket) {
        webSocket.setTextMessageConsumer(webSocketMessageIn -> {
            WebSocketMessage webSocketMessage = WebSocketMessageBuilder.webSocketMessageBuilder().setMessage(webSocketMessageIn).setUri(webSocket.uri()).setRemoteAddress(webSocket.remoteAddress()).setTimestamp(Timer.timer().now()).setSender(message -> {
                if (webSocket.isOpen()) {
                    webSocket.sendText(message);
                }
            }).build();
            this.handleWebSocketMessage(webSocketMessage);
        });
        webSocket.setBinaryMessageConsumer(webSocketMessageIn -> {
            WebSocketMessage webSocketMessage = WebSocketMessageBuilder.webSocketMessageBuilder().setMessage(webSocketMessageIn).setUri(webSocket.uri()).setRemoteAddress(webSocket.remoteAddress()).setTimestamp(Timer.timer().now()).setSender(new WebSocketSender(){

                @Override
                public void sendText(String message) {
                    webSocket.sendBinary(message.getBytes(StandardCharsets.UTF_8));
                }

                @Override
                public void sendBytes(byte[] message) {
                    webSocket.sendBinary(message);
                }
            }).build();
            this.handleWebSocketMessage(webSocketMessage);
        });
        webSocket.setCloseConsumer(aVoid -> {
            long time = Timer.timer().now();
            WebSocketMessage webSocketMessage = WebSocketMessageBuilder.webSocketMessageBuilder().setUri(webSocket.uri()).setRemoteAddress(webSocket.remoteAddress()).setTimestamp(time).build();
            this.handleWebSocketClosedMessage(webSocketMessage);
        });
        webSocket.setErrorConsumer(e -> this.logger.error("Error with WebSocket handling", (Throwable)e));
    }

    @Override
    public void setWebSocketOnOpenConsumer(Consumer<WebSocket> onOpenConsumer) {
        this.webSocketConsumer = onOpenConsumer;
    }

    public CopyOnWriteArrayList<HttpResponseDecorator> getDecorators() {
        return this.decorators;
    }

    public HttpResponseCreator getHttpResponseCreator() {
        return this.httpResponseCreator;
    }
}

