/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.server.websocket;

import io.advantageous.qbit.http.websocket.WebSocketSender;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.Timer;

public class WebSocketMessage
implements Request<Object>,
Cloneable {
    private static final ThreadLocal<RequestIdGenerator> idGen = new ThreadLocal<RequestIdGenerator>(){

        @Override
        protected RequestIdGenerator initialValue() {
            return new RequestIdGenerator();
        }
    };
    private final String uri;
    private final Object message;
    private final WebSocketSender sender;
    private final String remoteAddress;
    private final long messageId;
    private final long timestamp;
    private boolean handled;

    public WebSocketMessage(long id, long timestamp, String uri, Object message, String remoteAddress, WebSocketSender sender) {
        this.uri = uri;
        this.message = message;
        this.sender = sender;
        this.remoteAddress = remoteAddress;
        this.messageId = id <= 0L ? WebSocketMessage.idGen.get().inc() : id;
        this.timestamp = id <= 0L ? Timer.timer().now() : timestamp;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String address() {
        return this.uri;
    }

    @Override
    public String returnAddress() {
        return this.remoteAddress;
    }

    @Override
    public MultiMap<String, String> params() {
        return MultiMap.empty();
    }

    @Override
    public MultiMap<String, String> headers() {
        return MultiMap.empty();
    }

    @Override
    public boolean hasParams() {
        return false;
    }

    @Override
    public boolean hasHeaders() {
        return false;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isHandled() {
        return this.handled;
    }

    @Override
    public void handled() {
        this.handled = true;
    }

    @Override
    public long id() {
        return this.messageId;
    }

    @Override
    public Object body() {
        return this.message;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getUri() {
        return this.uri;
    }

    public Object getMessage() {
        return this.message;
    }

    public WebSocketSender getSender() {
        return this.sender;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketMessage that = (WebSocketMessage)o;
        if (this.messageId != that.messageId) {
            return false;
        }
        if (this.timestamp != that.timestamp) {
            return false;
        }
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "WebSocketMessage{uri='" + this.uri + '\'' + ", message='" + this.message + '\'' + ", sender=" + this.sender + ", remoteAddress='" + this.remoteAddress + '\'' + ", messageId=" + this.messageId + ", timestamp=" + this.timestamp + ", handled=" + this.handled + '}';
    }

    private static class RequestIdGenerator {
        private long value;

        private RequestIdGenerator() {
        }

        private long inc() {
            return this.value++;
        }
    }
}

