/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.http.websocket;

import io.advantageous.qbit.http.websocket.WebSocket;
import io.advantageous.qbit.http.websocket.WebSocketSender;
import io.advantageous.qbit.http.websocket.impl.WebSocketImpl;
import io.advantageous.qbit.util.MultiMap;

public class WebSocketBuilder {
    private String remoteAddress;
    private String uri;
    private boolean open;
    private WebSocketSender webSocketSender;
    private boolean binary;
    private MultiMap<String, String> headers = MultiMap.empty();
    private MultiMap<String, String> params = MultiMap.empty();

    public static WebSocketBuilder webSocketBuilder() {
        return new WebSocketBuilder();
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public WebSocketBuilder setHeaders(MultiMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public MultiMap<String, String> getParams() {
        return this.params;
    }

    public WebSocketBuilder setParams(MultiMap<String, String> params) {
        this.params = params;
        return this;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public WebSocketBuilder setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public WebSocketBuilder setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public WebSocketSender getWebSocketSender() {
        return this.webSocketSender;
    }

    public WebSocketBuilder setWebSocketSender(WebSocketSender webSocketSender) {
        this.webSocketSender = webSocketSender;
        return this;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public WebSocketBuilder setBinary(boolean binary) {
        this.binary = binary;
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public WebSocketBuilder setOpen(boolean open) {
        this.open = open;
        return this;
    }

    public WebSocket build() {
        return new WebSocketImpl(this.getRemoteAddress(), this.getUri(), this.isOpen(), this.isBinary(), this.webSocketSender, this.headers, this.params);
    }
}

