/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.kvstore;

import io.advantageous.qbit.QBit;
import io.advantageous.qbit.json.JsonMapper;
import io.advantageous.qbit.kvstore.impl.StringDecoderEncoderKeyValueStore;
import io.advantageous.qbit.kvstore.lowlevel.LowLevelKeyValueStoreService;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.reactive.ReactorBuilder;
import java.util.List;

public class JsonKeyValueStoreServiceBuilder {
    private LowLevelKeyValueStoreService lowLevelKeyValueStoreService;
    private JsonMapper jsonMapper;
    private Reactor reactor;

    public Reactor getReactor() {
        if (this.reactor == null) {
            this.reactor = ReactorBuilder.reactorBuilder().build();
        }
        return this.reactor;
    }

    public JsonKeyValueStoreServiceBuilder setReactor(Reactor reactor) {
        this.reactor = reactor;
        return this;
    }

    public JsonMapper getJsonMapper() {
        if (this.jsonMapper == null) {
            this.jsonMapper = QBit.factory().createJsonMapper();
        }
        return this.jsonMapper;
    }

    public JsonKeyValueStoreServiceBuilder setJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        return this;
    }

    public LowLevelKeyValueStoreService getLowLevelKeyValueStoreService() {
        return this.lowLevelKeyValueStoreService;
    }

    public JsonKeyValueStoreServiceBuilder setLowLevelKeyValueStoreService(LowLevelKeyValueStoreService lowLevelKeyValueStoreService) {
        this.lowLevelKeyValueStoreService = lowLevelKeyValueStoreService;
        return this;
    }

    public <T> StringDecoderEncoderKeyValueStore<List<T>> buildKeyListOfValueStore(Class<T> componentClass) {
        JsonMapper jsonMapper = this.getJsonMapper();
        return new StringDecoderEncoderKeyValueStore<List<T>>(json -> jsonMapper.fromJsonArray((String)json, componentClass), jsonMapper::toJson, this.getLowLevelKeyValueStoreService(), this.getReactor());
    }

    public <T> StringDecoderEncoderKeyValueStore<T> buildKeyValueStore(Class<T> componentClass) {
        JsonMapper jsonMapper = this.getJsonMapper();
        return new StringDecoderEncoderKeyValueStore<Object>(json -> jsonMapper.fromJson((String)json, componentClass), jsonMapper::toJson, this.getLowLevelKeyValueStoreService(), this.getReactor());
    }

    public static JsonKeyValueStoreServiceBuilder jsonKeyValueStoreServiceBuilder() {
        return new JsonKeyValueStoreServiceBuilder();
    }
}

