/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.kvstore;

import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.time.Duration;
import java.util.Optional;

public interface KeyValueStoreService<T> {
    default public void put(String key, T value) {
    }

    default public void putWithConfirmation(Callback<Boolean> confirmation, String key, T value) {
        confirmation.accept(true);
    }

    default public void putWithConfirmationAndTimeout(Callback<Boolean> confirmation, String key, T value, Duration expiry) {
        confirmation.accept(true);
    }

    default public void putWithTimeout(String key, T value, Duration expiry) {
    }

    default public void get(Callback<Optional<T>> callback, String key) {
        callback.returnThis(Optional.empty());
    }

    default public void hasKey(Callback<Boolean> hasKeyCallback, String key) {
        hasKeyCallback.returnThis(false);
    }

    default public void delete(String key) {
    }

    default public void deleteWithConfirmation(Callback<Boolean> confirmation, String key) {
        confirmation.returnThis(true);
    }

    default public void wipeCache() {
    }

    default public void process() {
    }
}

