/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.kvstore;

import io.advantageous.boon.primitive.SimpleLRUCache;
import io.advantageous.qbit.annotation.QueueCallback;
import io.advantageous.qbit.annotation.QueueCallbackType;
import io.advantageous.qbit.kvstore.FallbackReader;
import io.advantageous.qbit.kvstore.KeyValueStoreService;
import io.advantageous.qbit.kvstore.WriteBehindWriter;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.reactive.CallbackBuilder;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.time.Duration;
import io.advantageous.qbit.util.Timer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalKeyValueStoreService<T>
implements KeyValueStoreService<T> {
    private final StatsCollector statsCollector;
    private final String statKey;
    private long time = 0L;
    private int cacheSize = 0;
    private SimpleLRUCache<String, CacheEntry<T>> cache;
    private final FallbackReader<T> fallbackReader;
    private final WriteBehindWriter<T> writeBehindWriter;
    private final Reactor reactor;
    private final Logger logger = LoggerFactory.getLogger(LocalKeyValueStoreService.class);
    private final boolean debug;
    private final Timer timer;

    public LocalKeyValueStoreService(Reactor reactor, Timer timer, FallbackReader<T> fallbackReader, WriteBehindWriter<T> writeBehindWriter, int cacheSize, Duration flushEvery, StatsCollector statsCollector, String statKey, Duration debugInterval, boolean debug) {
        this.fallbackReader = fallbackReader;
        this.writeBehindWriter = writeBehindWriter;
        this.cacheSize = cacheSize;
        this.reactor = reactor;
        this.reactor.addRepeatingTask(flushEvery, this::initCache);
        this.statsCollector = statsCollector;
        this.timer = timer;
        this.statKey = statKey;
        if (debugInterval != Duration.NEVER) {
            this.reactor.addRepeatingTask(flushEvery, this::debugCache);
        }
        this.debug = debug || this.logger.isDebugEnabled();
        this.initCache();
    }

    private void debugCache() {
        this.cache.keys().forEach(s -> this.logger.info("CACHE ENTRY {}", this.cache.getSilent(s)));
    }

    private void initCache() {
        this.logger.info("flushing cache");
        this.cache = new SimpleLRUCache(this.cacheSize);
    }

    private CacheEntry<T> cacheEntry(String key, T value) {
        return new CacheEntry<T>(key, value, this.time, Optional.empty());
    }

    private CacheEntry<T> cacheEntryWithExpiry(String key, T value, Duration duration) {
        return new CacheEntry<T>(key, value, this.time, Optional.of(duration));
    }

    @Override
    public void put(String key, T value) {
        this.cache.put((Object)key, this.cacheEntry(key, value));
        this.writeBehindWriter.write(key, value);
    }

    @Override
    public void putWithConfirmation(Callback<Boolean> confirmation, String key, T value) {
        this.cache.put((Object)key, this.cacheEntry(key, value));
        CallbackBuilder callbackBuilder = this.reactor.callbackBuilder();
        if (this.debug) {
            callbackBuilder.wrapWithLogging(confirmation, this.logger, String.format("put with confirmation %s", key));
        } else {
            callbackBuilder.wrapWithLogging(confirmation, this.logger, "put with confirmation");
        }
        this.writeBehindWriter.writeWithConfirmation(callbackBuilder.build(), key, value);
    }

    @Override
    public void putWithConfirmationAndTimeout(Callback<Boolean> confirmation, String key, T value, Duration expiry) {
        this.cache.put((Object)key, this.cacheEntryWithExpiry(key, value, expiry));
        CallbackBuilder callbackBuilder = this.reactor.callbackBuilder();
        if (this.debug) {
            callbackBuilder.wrapWithLogging(confirmation, this.logger, String.format("put with confirmation %s and timeout %s", key, expiry));
        } else {
            callbackBuilder.wrapWithLogging(confirmation, this.logger, "put with confirmation and timeout");
        }
        this.writeBehindWriter.writeWithConfirmationAndTimeout(callbackBuilder.build(), key, value, expiry);
    }

    @Override
    public void putWithTimeout(String key, T value, Duration expiry) {
        this.cache.put((Object)key, this.cacheEntryWithExpiry(key, value, expiry));
        this.writeBehindWriter.writeWithTimeout(key, value, expiry);
    }

    @Override
    public void get(Callback<Optional<T>> callback, String key) {
        CacheEntry<T> cacheEntry = this.doGetCacheEntry(callback, key);
        if (cacheEntry == null) {
            CallbackBuilder callbackBuilder = this.reactor.callbackBuilder();
            if (this.debug) {
                callbackBuilder.wrapWithLogging(callback, this.logger, String.format("get  %s", key));
            } else {
                callbackBuilder.wrapWithLogging(callback, this.logger, "get operation");
            }
            this.fallbackReader.get(callbackBuilder.build(), key);
        }
    }

    private CacheEntry<T> doGetCacheEntry(Callback<Optional<T>> callback, String key) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.get((Object)key);
        if (cacheEntry != null) {
            if (cacheEntry.isExpired(this.time)) {
                this.statsCollector.increment(this.statKey + "expire");
                this.cache.remove((Object)key);
                return null;
            }
            Object value = cacheEntry.getValue();
            if (value == null) {
                callback.returnThis(Optional.empty());
            } else {
                this.statsCollector.increment(this.statKey + "cacheHit");
                callback.returnThis(Optional.of(value));
            }
        }
        return cacheEntry;
    }

    @Override
    public void hasKey(Callback<Boolean> hasKeyCallback, String key) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.getSilent((Object)key);
        if (cacheEntry != null) {
            if (cacheEntry.isExpired(this.time)) {
                this.statsCollector.increment(this.statKey + "expire");
                this.cache.remove((Object)key);
            } else {
                Object value = cacheEntry.getValue();
                if (value == null) {
                    hasKeyCallback.returnThis(false);
                } else {
                    hasKeyCallback.returnThis(true);
                }
                return;
            }
        }
        CallbackBuilder callbackBuilder = this.reactor.callbackBuilder();
        if (this.debug) {
            callbackBuilder.wrapWithLogging(hasKeyCallback, this.logger, String.format("get  %s", key));
        } else {
            callbackBuilder.wrapWithLogging(hasKeyCallback, this.logger, "hasKey operation");
        }
        this.fallbackReader.hasKey(callbackBuilder.build(), key);
    }

    @Override
    public void delete(String key) {
        this.cache.remove((Object)key);
        this.writeBehindWriter.delete(key);
    }

    @Override
    public void deleteWithConfirmation(Callback<Boolean> confirmation, String key) {
        this.cache.remove((Object)key);
        CallbackBuilder callbackBuilder = this.reactor.callbackBuilder();
        if (this.debug) {
            callbackBuilder.wrapWithLogging(confirmation, this.logger, String.format("get  %s", key));
        } else {
            callbackBuilder.wrapWithLogging(confirmation, this.logger, "hasKey operation");
        }
        this.writeBehindWriter.deleteWithConfirmation(callbackBuilder.build(), key);
    }

    @Override
    public void wipeCache() {
        this.initCache();
    }

    @Override
    @QueueCallback(value={QueueCallbackType.EMPTY, QueueCallbackType.LIMIT, QueueCallbackType.IDLE})
    public void process() {
        this.reactor.process();
        this.time = this.timer.time();
        this.fallbackReader.flushRequests();
        this.writeBehindWriter.flushRequests();
    }

    private class CacheEntry<V> {
        private final V value;
        private final Optional<Duration> expiry;
        private final String key;
        private final long createTime;

        public CacheEntry(String key, V value, long createTime, Optional<Duration> expiry) {
            LocalKeyValueStoreService.this.statsCollector.increment(LocalKeyValueStoreService.this.statKey + "cacheEntryAdded");
            this.value = value;
            this.expiry = expiry;
            this.key = key;
            this.createTime = createTime;
        }

        private boolean isExpired(long currentTime) {
            if (!this.expiry.isPresent()) {
                return false;
            }
            long duration = currentTime - this.createTime;
            return duration > this.expiry.get().toMillis();
        }

        public V getValue() {
            return this.value;
        }

        public String toString() {
            return "CacheEntry{value=" + this.value + ", expiry=" + this.expiry + ", key='" + this.key + '\'' + ", createTime=" + this.createTime + '}';
        }
    }
}

