/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.kvstore;

import io.advantageous.qbit.client.ClientProxy;
import io.advantageous.qbit.kvstore.FallbackReader;
import io.advantageous.qbit.kvstore.JsonKeyValueStoreServiceBuilder;
import io.advantageous.qbit.kvstore.KeyValueStoreService;
import io.advantageous.qbit.kvstore.LocalKeyValueStoreService;
import io.advantageous.qbit.kvstore.WriteBehindWriter;
import io.advantageous.qbit.kvstore.impl.StringDecoderEncoderKeyValueStore;
import io.advantageous.qbit.kvstore.lowlevel.LowLevelKeyValueStoreService;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.reactive.ReactorBuilder;
import io.advantageous.qbit.service.ServiceBuilder;
import io.advantageous.qbit.service.ServiceProxyUtils;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.time.Duration;
import io.advantageous.qbit.util.Timer;
import java.util.Optional;

public class LocalKeyValueStoreServiceBuilder<T> {
    private boolean debug;
    private Reactor reactor;
    private Timer timer;
    private Class<T> classType;
    private FallbackReader<T> fallbackReader;
    private WriteBehindWriter<T> writeBehindWriter;
    private int cacheSize = 10000;
    private Duration flushEvery = Duration.ONE_HOUR;
    private StatsCollector statsCollector;
    private String statKey = "qbit.kv.object.store.";
    private Duration debugInterval = Duration.NEVER;
    private ServiceBuilder serviceBuilder;

    public static <T> LocalKeyValueStoreServiceBuilder<T> localKeyValueStoreServiceBuilder(Class<T> classType) {
        LocalKeyValueStoreServiceBuilder<T> builder = new LocalKeyValueStoreServiceBuilder<T>();
        builder.setClassType(classType);
        return builder;
    }

    public LocalKeyValueStoreServiceBuilder<T> setWriteBehindAndReadFallbackAsLowLevel(LowLevelKeyValueStoreService lowLevelKVStore) {
        StringDecoderEncoderKeyValueStore<T> keyValueStore = JsonKeyValueStoreServiceBuilder.jsonKeyValueStoreServiceBuilder().setLowLevelKeyValueStoreService(lowLevelKVStore).buildKeyValueStore(this.getClassType());
        this.setWriteBehindAndReadFallback(keyValueStore);
        return this;
    }

    public LocalKeyValueStoreServiceBuilder<T> setWriteBehindAndReadFallback(KeyValueStoreService<T> keyValueStoreServiceInternal) {
        KeyValueStoreService keyValueStoreService = keyValueStoreServiceInternal instanceof ClientProxy ? keyValueStoreServiceInternal : this.getServiceBuilder().setServiceObject(keyValueStoreServiceInternal).buildAndStartAll().createProxy(KeyValueStoreService.class);
        this.setWriteBehind(keyValueStoreService);
        this.setReadFallback(keyValueStoreService);
        return this;
    }

    public LocalKeyValueStoreServiceBuilder<T> setWriteBehind(KeyValueStoreService<T> keyValueStoreServiceInternal) {
        final KeyValueStoreService keyValueStoreService = keyValueStoreServiceInternal instanceof ClientProxy ? keyValueStoreServiceInternal : this.getServiceBuilder().setServiceObject(keyValueStoreServiceInternal).buildAndStartAll().createProxy(KeyValueStoreService.class);
        this.setWriteBehindWriter(new WriteBehindWriter<T>(){

            @Override
            public void writeWithConfirmation(Callback<Boolean> confirmation, String key, T value) {
                keyValueStoreService.putWithConfirmation(confirmation, key, value);
            }

            @Override
            public void write(String key, T value) {
                keyValueStoreService.put(key, value);
            }

            @Override
            public void writeWithConfirmationAndTimeout(Callback<Boolean> confirmation, String key, T value, Duration expiry) {
                keyValueStoreService.putWithConfirmationAndTimeout(confirmation, key, value, expiry);
            }

            @Override
            public void writeWithTimeout(String key, T value, Duration expiry) {
                keyValueStoreService.putWithTimeout(key, value, expiry);
            }

            @Override
            public void delete(String key) {
                keyValueStoreService.delete(key);
            }

            @Override
            public void deleteWithConfirmation(Callback<Boolean> confirmation, String key) {
                keyValueStoreService.deleteWithConfirmation(confirmation, key);
            }

            @Override
            public void flushRequests() {
                ServiceProxyUtils.flushServiceProxy(keyValueStoreService);
            }
        });
        return this;
    }

    public LocalKeyValueStoreServiceBuilder<T> setReadFallback(KeyValueStoreService<T> keyValueStoreServiceInternal) {
        final KeyValueStoreService keyValueStoreService = keyValueStoreServiceInternal instanceof ClientProxy ? keyValueStoreServiceInternal : this.getServiceBuilder().setServiceObject(keyValueStoreServiceInternal).buildAndStartAll().createProxy(KeyValueStoreService.class);
        this.setFallbackReader(new FallbackReader<T>(){

            @Override
            public void get(Callback<Optional<T>> callback, String key) {
                keyValueStoreService.get(callback, key);
            }

            @Override
            public void hasKey(Callback<Boolean> callback, String key) {
                keyValueStoreService.hasKey(callback, key);
            }

            @Override
            public void flushRequests() {
                ServiceProxyUtils.flushServiceProxy(keyValueStoreService);
            }
        });
        return this;
    }

    public ServiceBuilder getServiceBuilder() {
        if (this.serviceBuilder == null) {
            this.serviceBuilder = new ServiceBuilder();
        }
        return this.serviceBuilder;
    }

    public LocalKeyValueStoreServiceBuilder setServiceBuilder(ServiceBuilder serviceBuilder) {
        this.serviceBuilder = serviceBuilder;
        return this;
    }

    public Reactor getReactor() {
        if (this.reactor == null) {
            this.reactor = ReactorBuilder.reactorBuilder().build();
        }
        return this.reactor;
    }

    public LocalKeyValueStoreServiceBuilder setReactor(Reactor reactor) {
        this.reactor = reactor;
        return this;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = Timer.timer();
        }
        return this.timer;
    }

    public LocalKeyValueStoreServiceBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public Class<T> getClassType() {
        return this.classType;
    }

    public LocalKeyValueStoreServiceBuilder setClassType(Class<T> classType) {
        this.classType = classType;
        return this;
    }

    public FallbackReader<T> getFallbackReader() {
        if (this.fallbackReader == null) {
            this.fallbackReader = new FallbackReader<T>(){};
        }
        return this.fallbackReader;
    }

    public LocalKeyValueStoreServiceBuilder setFallbackReader(FallbackReader<T> fallbackReader) {
        this.fallbackReader = fallbackReader;
        return this;
    }

    public WriteBehindWriter<T> getWriteBehindWriter() {
        if (this.writeBehindWriter == null) {
            this.writeBehindWriter = new WriteBehindWriter<T>(){};
        }
        return this.writeBehindWriter;
    }

    public LocalKeyValueStoreServiceBuilder setWriteBehindWriter(WriteBehindWriter<T> writeBehindWriter) {
        this.writeBehindWriter = writeBehindWriter;
        return this;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public LocalKeyValueStoreServiceBuilder setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public Duration getFlushEvery() {
        return this.flushEvery;
    }

    public LocalKeyValueStoreServiceBuilder setFlushEvery(Duration flushEvery) {
        this.flushEvery = flushEvery;
        return this;
    }

    public StatsCollector getStatsCollector() {
        if (this.statsCollector == null) {
            this.statsCollector = new StatsCollector(){};
        }
        return this.statsCollector;
    }

    public LocalKeyValueStoreServiceBuilder setStatsCollector(StatsCollector statsCollector) {
        this.statsCollector = statsCollector;
        return this;
    }

    public String getStatKey() {
        return this.statKey;
    }

    public LocalKeyValueStoreServiceBuilder setStatKey(String statKey) {
        this.statKey = statKey;
        return this;
    }

    public Duration getDebugInterval() {
        return this.debugInterval;
    }

    public LocalKeyValueStoreServiceBuilder setDebugInterval(Duration debugInterval) {
        this.debugInterval = debugInterval;
        return this;
    }

    public LocalKeyValueStoreService<T> build() {
        return new LocalKeyValueStoreService<T>(this.getReactor(), this.getTimer(), this.getFallbackReader(), this.getWriteBehindWriter(), this.getCacheSize(), this.getFlushEvery(), this.getStatsCollector(), this.getStatKey(), this.getDebugInterval(), this.getDebug());
    }

    public ServiceQueue buildAsService() {
        LocalKeyValueStoreService<T> kvStoreInternal = this.build();
        return this.getServiceBuilder().setServiceObject(kvStoreInternal).build();
    }

    public ServiceQueue buildAsServiceAndStartAll() {
        ServiceQueue serviceQueue = this.buildAsService();
        serviceQueue.startAll();
        return serviceQueue;
    }

    public LocalKeyValueStoreServiceBuilder setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public boolean getDebug() {
        return this.debug;
    }
}

