/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.kvstore.impl;

import io.advantageous.qbit.annotation.QueueCallback;
import io.advantageous.qbit.annotation.QueueCallbackType;
import io.advantageous.qbit.kvstore.KeyValueStoreService;
import io.advantageous.qbit.kvstore.lowlevel.LowLevelKeyValueStoreService;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.reactive.CallbackBuilder;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.time.Duration;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringDecoderEncoderKeyValueStore<T>
implements KeyValueStoreService<T> {
    private final Logger logger = LoggerFactory.getLogger(StringDecoderEncoderKeyValueStore.class);
    private final Function<String, T> fromStringFunction;
    private final Function<T, String> toStringFunction;
    private final LowLevelKeyValueStoreService kvStore;
    private final Reactor reactor;

    public StringDecoderEncoderKeyValueStore(Function<String, T> fromJsonFunction, Function<T, String> toJsonFunction, LowLevelKeyValueStoreService lowLevelKeyValueStoreService, Reactor reactor) {
        this.fromStringFunction = fromJsonFunction;
        this.toStringFunction = toJsonFunction;
        this.kvStore = lowLevelKeyValueStoreService;
        this.reactor = reactor;
    }

    @Override
    public void put(String key, T value) {
        this.kvStore.putString(key, this.toStringFunction.apply(value));
    }

    @Override
    public void putWithConfirmation(Callback<Boolean> confirmation, String key, T value) {
        this.kvStore.putStringWithConfirmation(this.reactor.wrapCallback(String.format("put key %s", key), confirmation, this.logger), key, this.toStringFunction.apply(value));
    }

    @Override
    public void putWithConfirmationAndTimeout(Callback<Boolean> confirmation, String key, T value, Duration expiry) {
        this.kvStore.putStringWithConfirmationAndTimeout(this.reactor.wrapCallback(String.format("put key %s %s", key, expiry), confirmation, this.logger), key, this.toStringFunction.apply(value), expiry);
    }

    @Override
    public void putWithTimeout(String key, T value, Duration expiry) {
        this.kvStore.putStringWithTimeout(key, this.toStringFunction.apply(value), expiry);
    }

    @Override
    public void get(Callback<Optional<T>> callback, String key) {
        CallbackBuilder callbackBuilder = this.reactor.callbackBuilder().delegateWithLogging(callback, this.logger, String.format("Getting key %s", key));
        callbackBuilder.withCallback(Optional.class, value -> {
            if (value.isPresent()) {
                callback.accept(Optional.of(this.fromStringFunction.apply(value.get().toString())));
            } else {
                callback.accept(Optional.empty());
            }
        });
        this.kvStore.getString(callbackBuilder.build(), key);
    }

    @Override
    public void hasKey(Callback<Boolean> hasKeyCallback, String key) {
        this.kvStore.hasKey(this.reactor.wrapCallback(String.format("has key key %s", key), hasKeyCallback, this.logger), key);
    }

    @Override
    public void delete(String key) {
        this.kvStore.delete(key);
    }

    @Override
    public void deleteWithConfirmation(Callback<Boolean> confirmation, String key) {
        this.kvStore.deleteWithConfirmation(this.reactor.wrapCallback(String.format("delete key %s", key), confirmation, this.logger), key);
    }

    @Override
    @QueueCallback(value={QueueCallbackType.EMPTY, QueueCallbackType.LIMIT, QueueCallbackType.IDLE})
    public void process() {
        this.kvStore.process();
        this.reactor.process();
    }
}

