/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.kvstore.lowlevel;

import io.advantageous.boon.primitive.SimpleLRUCache;
import io.advantageous.qbit.annotation.QueueCallback;
import io.advantageous.qbit.annotation.QueueCallbackType;
import io.advantageous.qbit.kvstore.lowlevel.LowLevelKeyValueStoreService;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.time.Duration;
import io.advantageous.qbit.util.Timer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowLevelLocalKeyValueStoreService
implements LowLevelKeyValueStoreService {
    private final int localCacheSize;
    private final Timer timer;
    private final Reactor reactor;
    private final StatsCollector statsCollector;
    public final String BASE_STAT_KEY = "qbit.kv.store.";
    public final String CACHE_SIZE_AT_FLUSH = "qbit.kv.store.flush.size";
    public final String CACHE_SIZE = "qbit.kv.store.cache.size";
    private SimpleLRUCache<String, CacheEntry> localCache;
    private long time;
    private final Logger logger = LoggerFactory.getLogger(LowLevelLocalKeyValueStoreService.class);

    public LowLevelLocalKeyValueStoreService(Timer timer, Reactor reactor, int localCacheSize, StatsCollector statsCollector, Optional<Duration> flushCacheDuration, boolean debug) {
        this.localCacheSize = localCacheSize;
        this.timer = timer;
        this.reactor = reactor;
        this.statsCollector = statsCollector;
        reactor.addServiceToFlush(statsCollector);
        if (flushCacheDuration.isPresent()) {
            reactor.addRepeatingTask(flushCacheDuration.get(), this::localCacheInit);
        }
        if (debug || this.logger.isDebugEnabled()) {
            reactor.addRepeatingTask(Duration.TEN_SECONDS, this::debug);
        }
        reactor.addRepeatingTask(Duration.FIVE_SECONDS, () -> statsCollector.recordLevel("qbit.kv.store.cache.size", this.localCache.size()));
        this.localCacheInit();
    }

    private void debug() {
        this.logger.info("DEBUG ############");
        this.logger.info("LOCAL CACHE KEYS {}", (Object)this.localCache.keys());
        this.logger.info("LOCAL CACHE VALUES {}", (Object)this.localCache.values());
        this.logger.info("DEBUG ############");
    }

    @Override
    @QueueCallback(value={QueueCallbackType.EMPTY, QueueCallbackType.LIMIT})
    public void process() {
        this.reactor.process();
        this.time = this.timer.time();
    }

    private void localCacheInit() {
        if (this.localCache != null) {
            this.statsCollector.recordLevel("qbit.kv.store.flush.size", this.localCache.size());
        }
        this.localCache = new SimpleLRUCache(this.localCacheSize);
    }

    @Override
    public void deleteWithConfirmation(Callback<Boolean> confirmation, String key) {
        this.localCache.remove((Object)key);
        confirmation.accept(true);
    }

    @Override
    public void putString(String key, String value) {
        this.localCache.put((Object)key, (Object)new CacheStringEntry(key, Optional.empty(), 0L, value));
    }

    @Override
    public void putBytes(String key, byte[] value) {
        this.localCache.put((Object)key, (Object)new CacheBytesEntry(key, Optional.empty(), 0L, value));
    }

    @Override
    public void putStringWithConfirmation(Callback<Boolean> confirmation, String key, String value) {
        this.localCache.put((Object)key, (Object)new CacheStringEntry(key, Optional.empty(), 0L, value));
        confirmation.returnThis(true);
    }

    @Override
    public void putBytesWithConfirmation(Callback<Boolean> confirmation, String key, byte[] value) {
        this.localCache.put((Object)key, (Object)new CacheBytesEntry(key, Optional.empty(), 0L, value));
        confirmation.returnThis(true);
    }

    @Override
    public void putStringWithConfirmationAndTimeout(Callback<Boolean> confirmation, String key, String value, Duration expiry) {
        this.localCache.put((Object)key, (Object)new CacheStringEntry(key, Optional.of(expiry), this.time, value));
        confirmation.returnThis(true);
    }

    @Override
    public void putBytesWithConfirmationAndTimeout(Callback<Boolean> confirmation, String key, byte[] value, Duration expiry) {
        this.localCache.put((Object)key, (Object)new CacheBytesEntry(key, Optional.of(expiry), this.time, value));
        confirmation.returnThis(true);
    }

    @Override
    public void putStringWithTimeout(String key, String value, Duration expiry) {
        this.localCache.put((Object)key, (Object)new CacheStringEntry(key, Optional.of(expiry), this.time, value));
    }

    @Override
    public void putBytesWithTimeout(String key, byte[] value, Duration expiry) {
        this.localCache.put((Object)key, (Object)new CacheBytesEntry(key, Optional.of(expiry), this.time, value));
    }

    @Override
    public void getString(Callback<Optional<String>> callback, String key) {
        CacheEntry cacheEntry = (CacheEntry)this.localCache.get((Object)key);
        if (cacheEntry == null) {
            callback.returnThis(Optional.empty());
            return;
        }
        if (cacheEntry.isExpired(this.time)) {
            this.localCache.remove((Object)key);
            callback.returnThis(Optional.empty());
        } else {
            String value = ((CacheStringEntry)cacheEntry).value;
            if (value == null) {
                callback.returnThis(Optional.empty());
            } else {
                callback.returnThis(Optional.of(value));
            }
        }
    }

    @Override
    public void getBytes(Callback<Optional<byte[]>> callback, String key) {
        CacheEntry cacheEntry = (CacheEntry)this.localCache.get((Object)key);
        if (cacheEntry == null) {
            callback.returnThis(Optional.empty());
            return;
        }
        if (cacheEntry.isExpired(this.time)) {
            this.localCache.remove((Object)key);
            callback.returnThis(Optional.empty());
        } else {
            byte[] value = ((CacheBytesEntry)cacheEntry).value;
            if (value == null) {
                callback.returnThis(Optional.empty());
            } else {
                callback.returnThis(Optional.of(value));
            }
        }
    }

    @Override
    public void hasKey(Callback<Boolean> hasKeyCallback, String key) {
        CacheEntry cacheEntry = (CacheEntry)this.localCache.getSilent((Object)key);
        if (cacheEntry == null) {
            hasKeyCallback.returnThis(false);
        } else if (cacheEntry.isExpired(this.time)) {
            this.localCache.remove((Object)key);
            hasKeyCallback.returnThis(false);
        } else {
            Object value = cacheEntry.getValue();
            if (value == null) {
                hasKeyCallback.returnThis(false);
            } else {
                hasKeyCallback.returnThis(true);
            }
        }
    }

    @Override
    public void delete(String key) {
        this.localCache.remove((Object)key);
    }

    private class CacheStringEntry
    extends CacheEntry {
        private final String value;

        private CacheStringEntry(String key, Optional<Duration> expiry, long createTime, String value) {
            super(expiry, key, createTime);
            this.value = value;
        }

        @Override
        Object getValue() {
            return this.value;
        }
    }

    private class CacheBytesEntry
    extends CacheEntry {
        private final byte[] value;

        private CacheBytesEntry(String key, Optional<Duration> expiry, long createTime, byte[] value) {
            super(expiry, key, createTime);
            this.value = value;
        }

        @Override
        Object getValue() {
            return this.value;
        }
    }

    private static abstract class CacheEntry {
        private final Optional<Duration> expiry;
        private final String key;
        private final long createTime;

        public CacheEntry(Optional<Duration> expiry, String key, long createTime) {
            this.expiry = expiry;
            this.key = key;
            this.createTime = createTime;
        }

        abstract Object getValue();

        private boolean isExpired(long currentTime) {
            if (!this.expiry.isPresent()) {
                return false;
            }
            long duration = currentTime - this.createTime;
            return duration > this.expiry.get().toMillis();
        }
    }
}

