/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.kvstore.lowlevel;

import io.advantageous.qbit.kvstore.lowlevel.LowLevelLocalKeyValueStoreService;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.reactive.ReactorBuilder;
import io.advantageous.qbit.service.ServiceBuilder;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.time.Duration;
import io.advantageous.qbit.util.Timer;
import java.util.Optional;

public class LowLevelLocalKeyValueStoreServiceBuilder {
    private Timer timer;
    private Reactor reactor;
    private int localCacheSize = 1000;
    private StatsCollector statsCollector;
    private Duration flushCacheDuration;
    private boolean debug;
    private ServiceBuilder serviceBuilder;

    public ServiceBuilder getServiceBuilder() {
        if (this.serviceBuilder == null) {
            this.serviceBuilder = new ServiceBuilder();
        }
        return this.serviceBuilder;
    }

    public LowLevelLocalKeyValueStoreServiceBuilder setServiceBuilder(ServiceBuilder serviceBuilder) {
        this.serviceBuilder = serviceBuilder;
        return this;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = Timer.timer();
        }
        return this.timer;
    }

    public LowLevelLocalKeyValueStoreServiceBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public Reactor getReactor() {
        if (this.reactor == null) {
            this.reactor = ReactorBuilder.reactorBuilder().build();
        }
        return this.reactor;
    }

    public LowLevelLocalKeyValueStoreServiceBuilder setReactor(Reactor reactor) {
        this.reactor = reactor;
        return this;
    }

    public int getLocalCacheSize() {
        return this.localCacheSize;
    }

    public LowLevelLocalKeyValueStoreServiceBuilder setLocalCacheSize(int localCacheSize) {
        this.localCacheSize = localCacheSize;
        return this;
    }

    public StatsCollector getStatsCollector() {
        if (this.statsCollector == null) {
            this.statsCollector = new StatsCollector(){

                @Override
                public void increment(String name) {
                }

                @Override
                public void recordCount(String name, long count) {
                }

                @Override
                public void recordLevel(String name, long level) {
                }

                @Override
                public void recordTiming(String name, long duration) {
                }
            };
        }
        return this.statsCollector;
    }

    public LowLevelLocalKeyValueStoreServiceBuilder setStatsCollector(StatsCollector statsCollector) {
        this.statsCollector = statsCollector;
        return this;
    }

    public Duration getFlushCacheDuration() {
        if (this.flushCacheDuration == null) {
            this.flushCacheDuration = Duration.hours(1L);
        }
        return this.flushCacheDuration;
    }

    public LowLevelLocalKeyValueStoreServiceBuilder useDefaultFlushCacheDuration() {
        this.getFlushCacheDuration();
        return this;
    }

    public LowLevelLocalKeyValueStoreServiceBuilder setFlushCacheDuration(Duration flushCacheDuration) {
        this.flushCacheDuration = flushCacheDuration;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public LowLevelLocalKeyValueStoreServiceBuilder setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public LowLevelLocalKeyValueStoreService build() {
        return new LowLevelLocalKeyValueStoreService(this.getTimer(), this.getReactor(), this.getLocalCacheSize(), this.getStatsCollector(), this.flushCacheDuration == null ? Optional.empty() : Optional.of(this.getFlushCacheDuration()), this.isDebug());
    }

    public ServiceQueue buildAsService() {
        LowLevelLocalKeyValueStoreService kvStoreInternal = this.build();
        return this.getServiceBuilder().setServiceObject(kvStoreInternal).build();
    }

    public ServiceQueue buildAsServiceAndStartAll() {
        ServiceQueue serviceQueue = this.buildAsService();
        serviceQueue.startAll();
        return serviceQueue;
    }

    public static LowLevelLocalKeyValueStoreServiceBuilder localKeyValueStoreBuilder() {
        return new LowLevelLocalKeyValueStoreServiceBuilder();
    }
}

