/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.kvstore.lowlevel;

import io.advantageous.qbit.annotation.QueueCallback;
import io.advantageous.qbit.annotation.QueueCallbackType;
import io.advantageous.qbit.kvstore.impl.StringDecoderEncoderKeyValueStore;
import io.advantageous.qbit.kvstore.lowlevel.LowLevelKeyValueStoreService;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.reactive.CallbackBuilder;
import io.advantageous.qbit.reactive.CallbackCoordinator;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.time.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowLevelWriteBehindReadFallbackKeyValueStore
implements LowLevelKeyValueStoreService {
    private final Logger logger = LoggerFactory.getLogger(StringDecoderEncoderKeyValueStore.class);
    private final LowLevelKeyValueStoreService localKeyValueStore;
    private final LowLevelKeyValueStoreService remoteKeyValueStore;
    private final Reactor reactor;

    public LowLevelWriteBehindReadFallbackKeyValueStore(LowLevelKeyValueStoreService localKeyValueStore, LowLevelKeyValueStoreService remoteKeyValueStore, Reactor reactor) {
        this.localKeyValueStore = localKeyValueStore;
        this.remoteKeyValueStore = remoteKeyValueStore;
        this.reactor = reactor;
        this.reactor.addServiceToFlush(this.localKeyValueStore);
        this.reactor.addServiceToFlush(this.remoteKeyValueStore);
    }

    private CallbackBuilder getCallbackBuilderForPut(Callback<Boolean> confirmation, String key) {
        AtomicInteger count = new AtomicInteger();
        AtomicBoolean failed = new AtomicBoolean();
        CallbackBuilder callbackBuilder = this.reactor.callbackBuilder();
        callbackBuilder.withBooleanCallback(success -> {
            long currentCount = count.incrementAndGet();
            this.logger.info("CURRENT COUNT {}", (Object)currentCount);
        }).withErrorHandler(error -> {
            this.logger.error(String.format("Failed to put key %s", key), error);
            failed.set(true);
            count.incrementAndGet();
        }).withTimeoutHandler(() -> {
            this.logger.error(String.format("Timeout trying to put key %s", key));
            failed.set(true);
            confirmation.onTimeout();
            count.incrementAndGet();
        });
        CallbackCoordinator callbackCoordinator = () -> {
            if (count.get() >= 2) {
                this.logger.info("DONE PROCESSING");
                return true;
            }
            return false;
        };
        this.reactor.coordinatorBuilder().setCoordinator(callbackCoordinator).setFinishedHandler(() -> {
            if (failed.get()) {
                return;
            }
            confirmation.accept(true);
        }).setTimeOutHandler(() -> {
            if (failed.get()) {
                return;
            }
            failed.set(true);
            this.logger.error(String.format("Timeout trying to put key %s", key));
            confirmation.onTimeout();
        }).build();
        return callbackBuilder;
    }

    @Override
    public void putStringWithConfirmationAndTimeout(Callback<Boolean> confirmation, String key, String value, Duration expiry) {
        CallbackBuilder callbackBuilder = this.getCallbackBuilderForPut(confirmation, key);
        this.localKeyValueStore.putStringWithConfirmationAndTimeout(callbackBuilder.build(), key, value, expiry);
        this.remoteKeyValueStore.putStringWithConfirmationAndTimeout(callbackBuilder.build(), key, value, expiry);
    }

    @Override
    public void putStringWithTimeout(String key, String value, Duration expiry) {
        this.localKeyValueStore.putStringWithTimeout(key, value, expiry);
        this.remoteKeyValueStore.putStringWithTimeout(key, value, expiry);
    }

    @Override
    public void getString(Callback<Optional<String>> callback, String key) {
        CallbackBuilder callbackBuilderForLocal = this.reactor.callbackBuilder().delegateWithLogging(callback, this.logger, String.format("Get %s from local", key));
        callbackBuilderForLocal.withCallback(Optional.class, optional -> {
            if (optional.isPresent()) {
                callback.returnThis((Optional<String>)optional);
            } else {
                CallbackBuilder callbackBuilderForRemote = this.reactor.callbackBuilder().delegateWithLogging(callback, this.logger, String.format("Get %s from remote", key));
                callbackBuilderForRemote.withCallback(Optional.class, callback::returnThis);
                this.remoteKeyValueStore.getString(callbackBuilderForRemote.build(), key);
            }
        });
        this.localKeyValueStore.getString(callbackBuilderForLocal.build(), key);
    }

    @Override
    public void putString(String key, String value) {
        this.localKeyValueStore.putString(key, value);
        this.remoteKeyValueStore.putString(key, value);
    }

    @Override
    public void putBytes(String key, byte[] value) {
        this.localKeyValueStore.putBytes(key, value);
        this.remoteKeyValueStore.putBytes(key, value);
    }

    @Override
    public void putStringWithConfirmation(Callback<Boolean> confirmation, String key, String value) {
        CallbackBuilder callbackBuilder = this.getCallbackBuilderForPut(confirmation, key);
        this.localKeyValueStore.putStringWithConfirmation(callbackBuilder.build(), key, value);
        this.remoteKeyValueStore.putStringWithConfirmation(callbackBuilder.build(), key, value);
    }

    @Override
    public void putBytesWithConfirmation(Callback<Boolean> confirmation, String key, byte[] value) {
        CallbackBuilder callbackBuilder = this.getCallbackBuilderForPut(confirmation, key);
        this.localKeyValueStore.putBytesWithConfirmation(callbackBuilder.build(), key, value);
        this.remoteKeyValueStore.putBytesWithConfirmation(callbackBuilder.build(), key, value);
    }

    @Override
    public void putBytesWithConfirmationAndTimeout(Callback<Boolean> confirmation, String key, byte[] value, Duration expiry) {
        CallbackBuilder callbackBuilder = this.getCallbackBuilderForPut(confirmation, key);
        this.localKeyValueStore.putBytesWithConfirmationAndTimeout(callbackBuilder.build(), key, value, expiry);
        this.remoteKeyValueStore.putBytesWithConfirmationAndTimeout(callbackBuilder.build(), key, value, expiry);
    }

    @Override
    public void putBytesWithTimeout(String key, byte[] value, Duration expiry) {
        this.localKeyValueStore.putBytesWithTimeout(key, value, expiry);
        this.remoteKeyValueStore.putBytesWithTimeout(key, value, expiry);
    }

    @Override
    public void getBytes(Callback<Optional<byte[]>> callback, String key) {
        CallbackBuilder callbackBuilderForLocal = this.reactor.callbackBuilder().delegateWithLogging(callback, this.logger, String.format("Get %s from local", key));
        callbackBuilderForLocal.withCallback(Optional.class, optional -> {
            if (optional.isPresent()) {
                callback.returnThis((Optional<byte[]>)optional);
            } else {
                CallbackBuilder callbackBuilderForRemote = this.reactor.callbackBuilder().delegateWithLogging(callback, this.logger, String.format("Get %s from remote", key));
                callbackBuilderForRemote.withCallback(Optional.class, callback::returnThis);
                this.remoteKeyValueStore.getBytes(callbackBuilderForRemote.build(), key);
            }
        });
        this.localKeyValueStore.getBytes(callbackBuilderForLocal.build(), key);
    }

    @Override
    public void hasKey(Callback<Boolean> hasKeyCallback, String key) {
        CallbackBuilder callbackBuilderForLocal = this.reactor.callbackBuilder().delegateWithLogging(hasKeyCallback, this.logger, String.format("Get %s from local", key));
        callbackBuilderForLocal.withCallback(Boolean.class, present -> {
            if (present.booleanValue()) {
                hasKeyCallback.returnThis(true);
            } else {
                CallbackBuilder callbackBuilderForRemote = this.reactor.callbackBuilder().delegateWithLogging(hasKeyCallback, this.logger, String.format("Get %s from remote", key));
                callbackBuilderForRemote.withCallback(Boolean.class, hasKeyCallback::returnThis);
                this.remoteKeyValueStore.hasKey(callbackBuilderForRemote.build(), key);
            }
        });
        this.localKeyValueStore.hasKey(callbackBuilderForLocal.build(), key);
    }

    @Override
    public void delete(String key) {
        this.localKeyValueStore.delete(key);
        this.remoteKeyValueStore.delete(key);
    }

    @Override
    public void deleteWithConfirmation(Callback<Boolean> confirmation, String key) {
        CallbackBuilder callbackBuilder = this.getCallbackBuilderForPut(confirmation, key);
        this.localKeyValueStore.deleteWithConfirmation(callbackBuilder.build(), key);
        this.remoteKeyValueStore.deleteWithConfirmation(callbackBuilder.build(), key);
    }

    @Override
    @QueueCallback(value={QueueCallbackType.EMPTY, QueueCallbackType.LIMIT, QueueCallbackType.IDLE})
    public void process() {
        this.reactor.process();
        this.remoteKeyValueStore.process();
        this.localKeyValueStore.process();
    }
}

