/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.message;

import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.impl.MethodCallImpl;
import io.advantageous.qbit.util.MultiMap;
import java.util.Collections;
import java.util.List;

public class MethodCallBuilder {
    private long timestamp;
    private long id = -1L;
    private String name = "";
    private String address = "";
    private MultiMap<String, String> params = MultiMap.empty();
    private MultiMap<String, String> headers = MultiMap.empty();
    private Object body = Collections.emptyList();
    private String objectName;
    private String returnAddress;
    private Request<Object> originatingRequest;

    public static MethodCallBuilder methodCallBuilder() {
        return new MethodCallBuilder();
    }

    public static MethodCall<Object> transformed(MethodCall<Object> methodCall, Object arg) {
        return new MethodCallBuilder().setTimestamp(methodCall.timestamp()).setId(methodCall.id()).setName(methodCall.name()).setAddress(methodCall.address()).setParams(methodCall.params()).setHeaders(methodCall.headers()).setBody(arg).setObjectName(methodCall.objectName()).setReturnAddress(methodCall.returnAddress()).setOriginatingRequest(methodCall.originatingRequest()).build();
    }

    public static MethodCall<Object> createMethodCallToBeEncodedAndSent(long id, String address, String returnAddress, String objectName, String methodName, long timestamp, Object body, MultiMap<String, String> params) {
        return new MethodCallBuilder().setId(id).setAddress(address).setReturnAddress(returnAddress).setObjectName(objectName).setName(methodName).setTimestamp(timestamp).setBody(body).setParams(params).build();
    }

    public static MethodCall<Object> methodWithArgs(String name, Object ... args) {
        return new MethodCallBuilder().setName(name).setBody(args).build();
    }

    public static MethodCall<Object> method(String name, List body) {
        return new MethodCallBuilder().setName(name).setBody(body).build();
    }

    public static MethodCall<Object> method(String name, String body) {
        return new MethodCallBuilder().setName(name).setBody(body).build();
    }

    public static MethodCall<Object> method(String name, String address, String body) {
        return new MethodCallBuilder().setName(name).setBody(body).setAddress(address).build();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public MethodCallBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public long getId() {
        return this.id;
    }

    public MethodCallBuilder setId(long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MethodCallBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public MethodCallBuilder setAddress(String address) {
        this.address = address == null ? "" : address;
        return this;
    }

    public MultiMap<String, String> getParams() {
        return this.params;
    }

    public MethodCallBuilder setParams(MultiMap<String, String> params) {
        this.params = params;
        return this;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public MethodCallBuilder setHeaders(MultiMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public MethodCallBuilder setBody(Object body) {
        this.body = body;
        return this;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public MethodCallBuilder setObjectName(String objectName) {
        this.objectName = objectName;
        return this;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public MethodCallBuilder setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
        return this;
    }

    public Request<Object> getOriginatingRequest() {
        return this.originatingRequest;
    }

    public MethodCallBuilder setOriginatingRequest(Request<Object> originatingRequest) {
        this.originatingRequest = originatingRequest;
        return this;
    }

    public MethodCall<Object> build() {
        return new MethodCallImpl(this.getTimestamp(), this.getId(), this.getName(), this.getAddress(), this.getParams(), this.getHeaders(), this.getBody(), this.getObjectName(), this.getReturnAddress(), this.getOriginatingRequest());
    }

    public boolean hasParams() {
        return this.params != null && this.params.size() > 0;
    }

    public void overridesFromParams() {
        if (this.params != null && this.params.size() > 0) {
            String _addr = (String)this.params.get("addressOfService");
            String _objectName = (String)this.params.get("objectName");
            String _methodName = (String)this.params.get("methodName");
            String _returnAddress = (String)this.params.get("addressOfReturn");
            this.address = _addr == null || _addr.isEmpty() ? this.address : _addr;
            this.returnAddress = _returnAddress == null || _returnAddress.isEmpty() ? this.returnAddress : _returnAddress;
            this.name = _methodName == null || _methodName.isEmpty() ? this.name : _methodName;
            this.objectName = _objectName == null || _objectName.isEmpty() ? this.objectName : _objectName;
        }
    }
}

