/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.message.impl;

import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.util.MultiMap;

public class MethodCallImpl
implements MethodCall<Object> {
    private final long timestamp;
    private final long id;
    private final String name;
    private final String address;
    private final MultiMap<String, String> params;
    private final MultiMap<String, String> headers;
    private final Object body;
    private final String objectName;
    private final String returnAddress;
    private final boolean hasCallback;
    private Object transformedBody;
    private Request<Object> originatingRequest;

    @Override
    public boolean hasCallback() {
        return this.hasCallback;
    }

    public MethodCallImpl(long timestamp, long id, String name, String address, MultiMap<String, String> params, MultiMap<String, String> headers, Object body, String objectName, String returnAddress, Request<Object> originatingRequest) {
        this.timestamp = timestamp;
        this.id = id;
        this.name = name;
        this.address = address;
        this.params = params;
        this.headers = headers;
        this.body = body;
        this.objectName = objectName;
        this.returnAddress = returnAddress;
        this.originatingRequest = originatingRequest;
        this.hasCallback = this.detectCallback();
    }

    private boolean detectCallback() {
        Object[] args = this.args();
        for (int index = 0; index < args.length; ++index) {
            if (!(args[index] instanceof Callback)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isHandled() {
        return false;
    }

    @Override
    public void handled() {
    }

    @Override
    public String objectName() {
        return this.objectName;
    }

    @Override
    public Request<Object> originatingRequest() {
        return this.originatingRequest;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String returnAddress() {
        return this.returnAddress;
    }

    @Override
    public MultiMap<String, String> params() {
        return this.params;
    }

    @Override
    public MultiMap<String, String> headers() {
        return this.headers;
    }

    @Override
    public Object body() {
        return this.transformedBody == null ? this.body : this.transformedBody;
    }

    public void setBody(Object[] body) {
        this.transformedBody = body;
    }

    public void originatingRequest(Request<Object> originatingRequest) {
        this.originatingRequest = originatingRequest;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean hasParams() {
        return this.params != null && this.params.size() > 0;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && this.headers.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodCallImpl)) {
            return false;
        }
        MethodCallImpl method = (MethodCallImpl)o;
        return !(this.id != method.id || (this.address == null ? method.address != null : !this.address.equals(method.address)) || (this.body == null ? method.body != null : !this.body.equals(method.body)) || (this.name == null ? method.name != null : !this.name.equals(method.name)) || (this.params == null ? method.params != null : !this.params.equals(method.params)));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return "MethodCallImpl{name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", params=" + this.params + ", body=" + this.body + ", timestamp=" + this.timestamp + ", id=" + this.id + ", objectName='" + this.objectName + '\'' + ", returnAddress='" + this.returnAddress + '\'' + '}';
    }
}

