/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.message.impl;

import io.advantageous.boon.core.Exceptions;
import io.advantageous.qbit.annotation.JsonIgnore;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import java.util.Map;

public class ResponseImpl<T>
implements Response<T> {
    private final Request<Object> request;
    private final String address;
    private final String returnAddress;
    private final Map<String, Object> params;
    private final Object body;
    private final long id;
    private final long timestamp;
    @JsonIgnore
    private transient Object transformedBody;
    private boolean errors;

    public ResponseImpl(MethodCall<Object> methodCall, T returnValue) {
        this.address = methodCall.address();
        this.returnAddress = methodCall.returnAddress();
        this.timestamp = methodCall.timestamp();
        this.id = methodCall.id();
        this.params = null;
        this.body = returnValue;
        this.request = methodCall;
    }

    public ResponseImpl(MethodCall<Object> methodCall, Throwable ex) {
        this.returnAddress = methodCall.returnAddress();
        this.timestamp = methodCall.timestamp();
        this.id = methodCall.id();
        this.body = ex instanceof Exceptions.SoftenedException ? ex.getCause() : ex;
        this.transformedBody = null;
        this.address = methodCall.address();
        this.errors = true;
        this.params = null;
        this.request = methodCall;
    }

    public ResponseImpl(long id, long timestamp, String address, String returnAddress, Map<String, Object> params, Object body, Request<Object> request, boolean errors) {
        this.address = address;
        this.params = params;
        this.body = body;
        this.id = id;
        this.timestamp = timestamp;
        this.returnAddress = returnAddress;
        this.request = request;
        this.errors = errors;
    }

    public static Response<Object> response(long id, long timestamp, String address, String returnAddress, Object body, Request<Object> requestForResponse, boolean errors) {
        return new ResponseImpl<Object>(id, timestamp, address, returnAddress, null, body, requestForResponse, errors);
    }

    public static Response<Object> response(long id, long timestamp, String address, String returnAddress, Object body, Request<Object> requestForResponse) {
        return new ResponseImpl<Object>(id, timestamp, address, returnAddress, null, body, requestForResponse, false);
    }

    public static Response<Object> response(MethodCall<Object> methodCall, Object returnValue) {
        ResponseImpl<Object> response = new ResponseImpl<Object>(methodCall, returnValue);
        return response;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public T body() {
        if (this.transformedBody == null) {
            return (T)this.body;
        }
        return (T)this.transformedBody;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean wasErrors() {
        return this.errors;
    }

    @Override
    public void body(T newBody) {
        this.transformedBody = newBody;
    }

    @Override
    public String returnAddress() {
        return this.returnAddress;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public Request<Object> request() {
        return this.request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponseImpl)) {
            return false;
        }
        ResponseImpl response = (ResponseImpl)o;
        if (this.address != null ? !this.address.equals(response.address) : response.address != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(response.body) : response.body != null) {
            return false;
        }
        return !(this.params == null ? response.params != null : !this.params.equals(response.params));
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResponseImpl{request=" + this.request + ", address='" + this.address + '\'' + ", returnAddress='" + this.returnAddress + '\'' + ", params=" + this.params + ", body=" + this.body + ", id=" + this.id + ", timestamp=" + this.timestamp + ", transformedBody=" + this.transformedBody + ", errors=" + this.errors + '}';
    }

    public static Response<Object> error(MethodCall<Object> methodCall, Throwable error) {
        return new ResponseImpl<Object>(methodCall, error);
    }
}

