/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.meta;

import io.advantageous.boon.core.TypeType;
import io.advantageous.qbit.meta.params.Param;

public class ParameterMeta {
    private final Class<?> classType;
    private final TypeType type;
    private final Param param;
    private final boolean collection;
    private final boolean map;
    private final boolean array;
    private final Class<?> componentClass;
    private final Class<?> componentClassKey;
    private final Class<?> componentClassValue;

    public ParameterMeta(Class<?> classType, TypeType type, Param param, boolean isCollection, boolean isMap, boolean isArray, Class<?> returnTypeComponent, Class<?> returnTypeComponentKey, Class<?> returnTypeComponentValue) {
        this.classType = classType;
        this.type = type;
        this.param = param;
        this.collection = isCollection;
        this.map = isMap;
        this.array = isArray;
        this.componentClass = returnTypeComponent;
        this.componentClassKey = returnTypeComponentKey;
        this.componentClassValue = returnTypeComponentValue;
    }

    public ParameterMeta(Class<?> classType, TypeType type, Param param) {
        this.classType = classType;
        this.type = type;
        this.param = param;
        this.collection = false;
        this.map = false;
        this.array = false;
        this.componentClass = null;
        this.componentClassKey = null;
        this.componentClassValue = null;
    }

    public static ParameterMeta[] parameters(ParameterMeta ... parameters) {
        return parameters;
    }

    public static ParameterMeta param(Class<?> classType, TypeType typeType, Param param) {
        return new ParameterMeta(classType, typeType, param);
    }

    public static ParameterMeta stringParam(Param param) {
        return new ParameterMeta(null, TypeType.STRING, param);
    }

    public static ParameterMeta intParam(Param param) {
        return new ParameterMeta(Integer.TYPE, TypeType.INT, param);
    }

    public static ParameterMeta floatParam(Param param) {
        return new ParameterMeta(Float.TYPE, TypeType.FLOAT, param);
    }

    public static ParameterMeta doubleParam(Param param) {
        return new ParameterMeta(Double.TYPE, TypeType.DOUBLE, param);
    }

    public static ParameterMeta objectParam(Param param) {
        return new ParameterMeta(Object.class, TypeType.OBJECT, param);
    }

    public static ParameterMeta paramMeta(TypeType typeType, Param param) {
        return new ParameterMeta(null, typeType, param);
    }

    public TypeType getType() {
        return this.type;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public Param getParam() {
        return this.param;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isMap() {
        return this.map;
    }

    public boolean isArray() {
        return this.array;
    }

    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public Class<?> getComponentClassKey() {
        return this.componentClassKey;
    }

    public Class<?> getComponentClassValue() {
        return this.componentClassValue;
    }

    public boolean isString() {
        return this.type == TypeType.STRING;
    }

    public boolean isByteArray() {
        return this.type == TypeType.ARRAY_BYTE;
    }
}

