/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.meta;

import io.advantageous.boon.core.Lists;
import io.advantageous.qbit.annotation.RequestMethod;
import io.advantageous.qbit.meta.CallType;
import io.advantageous.qbit.meta.ParameterMeta;
import java.util.Collections;
import java.util.List;

public class RequestMeta {
    private final CallType callType;
    private final String requestURI;
    private final List<ParameterMeta> parameters;
    private final List<RequestMethod> requestMethods;

    public RequestMeta(CallType callType, List<RequestMethod> requestMethods, String requestURI, List<ParameterMeta> parameterMetaList) {
        this.callType = callType;
        this.requestURI = requestURI;
        this.parameters = parameterMetaList;
        this.requestMethods = requestMethods;
    }

    public static RequestMeta[] requests(RequestMeta ... requests) {
        return requests;
    }

    public static List<RequestMethod> requestMethods(RequestMethod ... methods) {
        return Lists.list((Object[])methods);
    }

    public static RequestMeta requestMeta(CallType callType, RequestMethod requestMethod, String requestURI, ParameterMeta ... parameterMetaList) {
        return new RequestMeta(callType, Collections.singletonList(requestMethod), requestURI, Lists.list((Object[])parameterMetaList));
    }

    public static RequestMeta request(CallType callType, RequestMethod requestMethod, String requestURI, ParameterMeta ... parameterMetaList) {
        return new RequestMeta(callType, Collections.singletonList(requestMethod), requestURI, Lists.list((Object[])parameterMetaList));
    }

    public static RequestMeta request(CallType callType, List<RequestMethod> requestMethods, String requestURI, ParameterMeta ... parameterMetaList) {
        return new RequestMeta(callType, requestMethods, requestURI, Lists.list((Object[])parameterMetaList));
    }

    public static RequestMeta requestByAddress(RequestMethod requestMethod, String requestURI, ParameterMeta ... parameterMetaList) {
        if (!requestURI.contains("{")) {
            return new RequestMeta(CallType.ADDRESS, Collections.singletonList(requestMethod), requestURI, Lists.list((Object[])parameterMetaList));
        }
        return new RequestMeta(CallType.ADDRESS_WITH_PATH_PARAMS, Collections.singletonList(requestMethod), requestURI, Lists.list((Object[])parameterMetaList));
    }

    public static RequestMeta getRequest(String requestURI, ParameterMeta ... parameterMetaList) {
        return RequestMeta.requestByAddress(RequestMethod.GET, requestURI, parameterMetaList);
    }

    public static RequestMeta postRequest(String requestURI, ParameterMeta ... parameterMetaList) {
        return RequestMeta.requestByAddress(RequestMethod.POST, requestURI, parameterMetaList);
    }

    public static RequestMeta putRequest(String requestURI, ParameterMeta ... parameterMetaList) {
        return RequestMeta.requestByAddress(RequestMethod.PUT, requestURI, parameterMetaList);
    }

    public static RequestMeta deleteRequest(String requestURI, ParameterMeta ... parameterMetaList) {
        return RequestMeta.requestByAddress(RequestMethod.DELETE, requestURI, parameterMetaList);
    }

    public static RequestMeta headRequest(String requestURI, ParameterMeta ... parameterMetaList) {
        return RequestMeta.requestByAddress(RequestMethod.HEAD, requestURI, parameterMetaList);
    }

    public CallType getCallType() {
        return this.callType;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public List<ParameterMeta> getParameters() {
        return this.parameters;
    }

    public List<RequestMethod> getRequestMethods() {
        return this.requestMethods;
    }
}

