/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.meta.builder;

import io.advantageous.boon.core.Conversions;
import io.advantageous.boon.core.Lists;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.reflection.Annotated;
import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.qbit.annotation.RequestMethod;
import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.meta.ContextMeta;
import io.advantageous.qbit.meta.ServiceMeta;
import io.advantageous.qbit.meta.builder.ServiceMetaBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ContextMetaBuilder {
    public static final String CONTEXT = "qbit.contextBuilder.";
    private String rootURI = "/services";
    private List<ServiceMeta> services = new ArrayList<ServiceMeta>();
    private String title = "application title goes here";
    private String description = "Description not set";
    private String contactName = "ContactName not set";
    private String contactURL = "Contact URL not set";
    private String contactEmail = "no.contact.email@set.me.please.com";
    private String licenseName = "licenseName not set";
    private String licenseURL = "http://www.license.url.com/not/set/";
    private String version = "0.1-NOT-SET";
    private String hostAddress = "localhost";

    public ContextMetaBuilder(PropertyResolver propertyResolver) {
        this.description = propertyResolver.getStringProperty("description", this.description);
        this.contactName = propertyResolver.getStringProperty("contactName", this.contactName);
        this.contactEmail = propertyResolver.getStringProperty("contactEmail", this.contactEmail);
        this.licenseName = propertyResolver.getStringProperty("licenseName", this.licenseName);
        this.licenseURL = propertyResolver.getStringProperty("licenseURL", this.licenseURL);
        this.version = propertyResolver.getStringProperty("licenseURL", this.version);
        this.hostAddress = propertyResolver.getStringProperty("hostAddress", this.hostAddress);
        this.title = propertyResolver.getStringProperty("title", this.title);
    }

    public ContextMetaBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(CONTEXT, properties));
    }

    public ContextMetaBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(CONTEXT));
    }

    public static ContextMetaBuilder contextMetaBuilder() {
        return new ContextMetaBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public ContextMetaBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ContextMetaBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getContactName() {
        return this.contactName;
    }

    public ContextMetaBuilder setContactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    public String getContactURL() {
        return this.contactURL;
    }

    public ContextMetaBuilder setContactURL(String contactURL) {
        this.contactURL = contactURL;
        return this;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public ContextMetaBuilder setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public ContextMetaBuilder setLicenseName(String licenseName) {
        this.licenseName = licenseName;
        return this;
    }

    public String getLicenseURL() {
        return this.licenseURL;
    }

    public ContextMetaBuilder setLicenseURL(String licenseURL) {
        this.licenseURL = licenseURL;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ContextMetaBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public ContextMetaBuilder setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
        return this;
    }

    public static List<String> getRequestPathsByAnnotated(Annotated classMeta, String name) {
        Object value = ContextMetaBuilder.getRequestPath(classMeta, name);
        if (value instanceof String) {
            return Lists.list((Object[])new String[]{ContextMetaBuilder.asPath(value.toString())});
        }
        if (value instanceof String[]) {
            String[] varray = (String[])value;
            if (varray.length > 0) {
                return Lists.list((Object[])((String[])value));
            }
            return Lists.list((Object[])new String[]{"/" + name});
        }
        throw new IllegalStateException();
    }

    public static List<RequestMethod> getRequestMethodsByAnnotated(Annotated annotated) {
        AnnotationData requestMapping = annotated.annotation("RequestMapping");
        if (requestMapping == null) {
            return Collections.singletonList(RequestMethod.GET);
        }
        Object method = requestMapping.getValues().get("method");
        if (method == null) {
            return Collections.singletonList(RequestMethod.GET);
        }
        if (method instanceof RequestMethod[]) {
            List<RequestMethod> requestMethods = Arrays.asList((RequestMethod[])method);
            return requestMethods;
        }
        if (method instanceof Object[]) {
            Object[] methods = (Object[])method;
            if (methods.length == 0) {
                return Collections.singletonList(RequestMethod.GET);
            }
            ArrayList<RequestMethod> requestMethods = new ArrayList<RequestMethod>(methods.length);
            for (Object object : methods) {
                requestMethods.add(RequestMethod.valueOf(object.toString()));
            }
            return requestMethods;
        }
        return Collections.singletonList(RequestMethod.valueOf(method.toString()));
    }

    static Object getRequestPath(Annotated classMeta, String name) {
        AnnotationData requestMapping = classMeta.annotation("RequestMapping");
        if (requestMapping != null) {
            Object value = requestMapping.getValues().get("value");
            if (value == null) {
                value = "/" + name.toLowerCase();
            }
            return value;
        }
        return "/" + name.toLowerCase();
    }

    static String getDescriptionFromRequestMapping(Annotated annotated) {
        AnnotationData requestMapping = annotated.annotation("RequestMapping");
        if (requestMapping != null) {
            Object value = requestMapping.getValues().get("description");
            return value.toString();
        }
        return "no description";
    }

    static int getCodeFromRequestMapping(Annotated annotated) {
        AnnotationData requestMapping = annotated.annotation("RequestMapping");
        if (requestMapping != null) {
            Object value = requestMapping.getValues().get("code");
            return Conversions.toInt(value);
        }
        return -1;
    }

    static String getReturnDescriptionFromRequestMapping(Annotated annotated) {
        AnnotationData requestMapping = annotated.annotation("RequestMapping");
        if (requestMapping != null) {
            Object value = requestMapping.getValues().get("returnDescription");
            return value.toString();
        }
        return "no description of return";
    }

    static String getSummaryFromRequestMapping(Annotated annotated) {
        AnnotationData requestMapping = annotated.annotation("RequestMapping");
        if (requestMapping != null) {
            Object value = requestMapping.getValues().get("summary");
            return value.toString();
        }
        return "no summary";
    }

    public static String asPath(String s) {
        String path = s;
        if (!s.startsWith("/")) {
            path = "/" + s;
        }
        if (s.endsWith("/") && s.length() > 2) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String getRootURI() {
        return this.rootURI;
    }

    public ContextMetaBuilder setRootURI(String rootURI) {
        this.rootURI = rootURI;
        return this;
    }

    public List<ServiceMeta> getServices() {
        return this.services;
    }

    public ContextMetaBuilder setServices(List<ServiceMeta> services) {
        this.services = services;
        return this;
    }

    public ContextMetaBuilder addService(ServiceMeta service) {
        this.services.add(service);
        return this;
    }

    public ContextMetaBuilder addService(Class<?> serviceClass) {
        ClassMeta classMeta = ClassMeta.classMeta(serviceClass);
        String name = this.getServiceName(classMeta);
        List<String> requestPaths = ContextMetaBuilder.getRequestPathsByAnnotated((Annotated)classMeta, name);
        String description = ContextMetaBuilder.getDescriptionFromRequestMapping((Annotated)classMeta);
        ServiceMetaBuilder serviceMetaBuilder = ServiceMetaBuilder.serviceMetaBuilder().setRequestPaths(requestPaths).setName(name).setDescription(description);
        serviceMetaBuilder.addMethods(this.getRootURI(), Lists.list((Iterable)classMeta.methods()));
        this.addService(serviceMetaBuilder.build());
        return this;
    }

    private String getServiceName(ClassMeta<?> classMeta) {
        AnnotationData annotationData = classMeta.annotation("Name");
        String name = "";
        if (annotationData == null && (annotationData = classMeta.annotation("Service")) == null) {
            name = Str.camelCaseLower((String)classMeta.name());
        }
        if (annotationData != null) {
            name = annotationData.getValues().get("value").toString();
        }
        return name;
    }

    public ContextMetaBuilder addServices(ServiceMeta ... serviceArray) {
        Collections.addAll(this.services, serviceArray);
        return this;
    }

    public ContextMeta build() {
        return new ContextMeta(this.getTitle(), this.getRootURI(), this.getServices(), this.getDescription(), this.getContactName(), this.getContactURL(), this.getContactEmail(), this.getLicenseName(), this.getLicenseURL(), this.getVersion(), this.getHostAddress());
    }
}

