/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.meta.builder;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.qbit.annotation.RequestMethod;
import io.advantageous.qbit.meta.CallType;
import io.advantageous.qbit.meta.ParameterMeta;
import io.advantageous.qbit.meta.RequestMeta;
import io.advantageous.qbit.meta.builder.ParameterMetaBuilder;
import io.advantageous.qbit.meta.params.BodyParam;
import io.advantageous.qbit.meta.params.HeaderParam;
import io.advantageous.qbit.meta.params.Param;
import io.advantageous.qbit.meta.params.RequestParam;
import io.advantageous.qbit.meta.params.URINamedParam;
import io.advantageous.qbit.meta.params.URIPositionalParam;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RequestMetaBuilder {
    private CallType callType;
    private String requestURI;
    private List<ParameterMeta> parameters = new ArrayList<ParameterMeta>();
    private List<RequestMethod> requestMethods = new ArrayList<RequestMethod>();
    private String description;

    public static RequestMetaBuilder requestMetaBuilder() {
        return new RequestMetaBuilder();
    }

    public static int findURIPosition(String path, String findString) {
        String pathPart;
        int position;
        String[] pathParts = Str.split((String)path, (char)'/');
        for (position = 0; position < pathParts.length && !(pathPart = pathParts[position]).equals(findString); ++position) {
        }
        return position;
    }

    public String getDescription() {
        return this.description;
    }

    public RequestMetaBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public CallType getCallType() {
        return this.callType;
    }

    public RequestMetaBuilder setCallType(CallType callType) {
        this.callType = callType;
        return this;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public RequestMetaBuilder setRequestURI(String requestURI) {
        this.requestURI = requestURI;
        return this;
    }

    public List<ParameterMeta> getParameters() {
        return this.parameters;
    }

    public RequestMetaBuilder setParameters(List<ParameterMeta> parameters) {
        this.parameters = parameters;
        return this;
    }

    public RequestMetaBuilder addParameter(ParameterMeta parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public RequestMetaBuilder addParameters(ParameterMeta ... parameters) {
        Collections.addAll(this.getParameters(), parameters);
        return this;
    }

    public List<RequestMethod> getRequestMethods() {
        return this.requestMethods;
    }

    public RequestMetaBuilder setRequestMethods(List<RequestMethod> requestMethods) {
        this.requestMethods = requestMethods;
        return this;
    }

    public RequestMeta build() {
        return new RequestMeta(this.getCallType(), this.getRequestMethods(), this.getRequestURI(), this.getParameters());
    }

    public void addParameters(String rootPath, String servicePath, String path, MethodAccess methodAccess) {
        List paramsAnnotationData = methodAccess.annotationDataForParams();
        List typeTypes = methodAccess.paramTypeEnumList();
        ArrayList<ParameterMeta> params = new ArrayList<ParameterMeta>(typeTypes.size());
        block0: for (int index = 0; index < typeTypes.size(); ++index) {
            if (paramsAnnotationData.size() <= index) continue;
            List annotationDataList = (List)paramsAnnotationData.get(index);
            String finalPath = Str.join((String[])new String[]{"/", rootPath, servicePath, path}).replace("//", "/");
            if (annotationDataList == null || annotationDataList.size() == 0) {
                Param requestParam = this.getParam(finalPath, null, index);
                ParameterMeta param = this.createParamMeta(methodAccess, index, typeTypes, requestParam);
                params.add(param);
                continue;
            }
            for (AnnotationData annotationData : annotationDataList) {
                Param requestParam = this.getParam(finalPath, annotationData, index);
                if (requestParam == null) continue;
                ParameterMeta param = this.createParamMeta(methodAccess, index, typeTypes, requestParam);
                params.add(param);
                continue block0;
            }
        }
        this.parameters.addAll(params);
    }

    private ParameterMeta createParamMeta(MethodAccess methodAccess, int index, List<TypeType> typeTypes, Param requestParam) {
        ParameterMetaBuilder builder = ParameterMetaBuilder.parameterMetaBuilder();
        builder.setType(typeTypes.get(index));
        builder.setParam(requestParam);
        Type type = methodAccess.method().getGenericParameterTypes()[index];
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class containerClass = (Class)parameterizedType.getRawType();
            builder.setClassType(containerClass);
            if (Collection.class.isAssignableFrom(containerClass)) {
                builder.setCollection(true);
                builder.setComponentClass((Class)parameterizedType.getActualTypeArguments()[0]);
            } else if (Map.class.isAssignableFrom(containerClass)) {
                builder.setMap(true);
                builder.setComponentClassKey((Class)parameterizedType.getActualTypeArguments()[0]);
                builder.setComponentClassValue((Class)parameterizedType.getActualTypeArguments()[1]);
            }
        } else {
            Class<?> classType = methodAccess.method().getParameterTypes()[index];
            builder.setClassType(classType);
            builder.setComponentClass(classType.getComponentType());
            builder.setArray(classType.isArray());
        }
        return builder.build();
    }

    private Param getParam(String path, AnnotationData annotationData, int index) {
        Param param;
        if (annotationData == null) {
            return new BodyParam(true, null, null);
        }
        String paramName = this.getParamName(annotationData);
        boolean required = this.getRequired(annotationData);
        String description = this.getParamDescription(annotationData);
        String defaultValue = this.getDefaultValue(annotationData);
        switch (annotationData.getName()) {
            case "requestParam": {
                param = new RequestParam(required, paramName, defaultValue, description);
                break;
            }
            case "headerParam": {
                param = new HeaderParam(required, paramName, defaultValue, description);
                break;
            }
            case "pathVariable": {
                if (!path.contains("{")) {
                    throw new IllegalStateException();
                }
                if (paramName == null || Str.isEmpty((String)paramName)) {
                    String findString = "{" + index + "}";
                    int position = RequestMetaBuilder.findURIPosition(path, findString);
                    param = new URIPositionalParam(required, index, (Object)defaultValue, position, description);
                    break;
                }
                String findString = "{" + paramName + "}";
                int position = RequestMetaBuilder.findURIPosition(path, findString);
                param = new URINamedParam(required, paramName, (Object)defaultValue, position, description);
                break;
            }
            default: {
                param = null;
            }
        }
        return param;
    }

    private String getDefaultValue(AnnotationData annotationData) {
        if (annotationData == null) {
            return null;
        }
        Object value = annotationData.getValues().get("defaultValue");
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String getParamName(AnnotationData annotationData) {
        if (annotationData == null) {
            return null;
        }
        Object value = annotationData.getValues().get("value");
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String getParamDescription(AnnotationData annotationData) {
        if (annotationData == null) {
            return null;
        }
        Object value = annotationData.getValues().get("description");
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private Boolean getRequired(AnnotationData annotationData) {
        if (annotationData == null) {
            return false;
        }
        Object value = annotationData.getValues().get("required");
        if (value == null) {
            return false;
        }
        return value instanceof Boolean ? (Boolean)value : Boolean.valueOf(value.toString());
    }
}

