/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.meta.builder;

import io.advantageous.boon.core.reflection.Annotated;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.qbit.annotation.RequestMethod;
import io.advantageous.qbit.meta.CallType;
import io.advantageous.qbit.meta.ServiceMeta;
import io.advantageous.qbit.meta.ServiceMethodMeta;
import io.advantageous.qbit.meta.builder.ContextMetaBuilder;
import io.advantageous.qbit.meta.builder.RequestMetaBuilder;
import io.advantageous.qbit.meta.builder.ServiceMethodMetaBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ServiceMetaBuilder {
    private String name;
    private List<String> requestPaths = new ArrayList<String>();
    private List<ServiceMethodMeta> methods = new ArrayList<ServiceMethodMeta>();
    private String description;

    public String getDescription() {
        return this.description;
    }

    public ServiceMetaBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public static ServiceMetaBuilder serviceMetaBuilder() {
        return new ServiceMetaBuilder();
    }

    public String getName() {
        return this.name;
    }

    public ServiceMetaBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getRequestPaths() {
        return this.requestPaths;
    }

    public ServiceMetaBuilder setRequestPaths(List<String> requestPaths) {
        this.requestPaths = requestPaths;
        return this;
    }

    public ServiceMetaBuilder addRequestPath(String requestPath) {
        this.requestPaths.add(requestPath);
        return this;
    }

    public List<ServiceMethodMeta> getMethods() {
        return this.methods;
    }

    public ServiceMetaBuilder setMethods(List<ServiceMethodMeta> methods) {
        this.methods = methods;
        return this;
    }

    public ServiceMetaBuilder addMethod(ServiceMethodMeta method) {
        this.methods.add(method);
        return this;
    }

    public ServiceMetaBuilder addMethods(ServiceMethodMeta ... methodArray) {
        Collections.addAll(this.methods, methodArray);
        return this;
    }

    public ServiceMeta build() {
        return new ServiceMeta(this.getName(), this.getRequestPaths(), this.getMethods(), this.getDescription());
    }

    public void addMethods(String path, Collection<MethodAccess> methods) {
        methods.stream().filter(methodAccess -> !methodAccess.isPrivate() && !methodAccess.isStatic() && !methodAccess.method().isSynthetic()).forEach(methodAccess -> this.addMethod(path, (MethodAccess)methodAccess));
    }

    public ServiceMetaBuilder addMethod(String rootPath, MethodAccess methodAccess) {
        for (String servicePath : this.getRequestPaths()) {
            List<String> requestPaths = ContextMetaBuilder.getRequestPathsByAnnotated((Annotated)methodAccess, methodAccess.name().toLowerCase());
            String description = ContextMetaBuilder.getDescriptionFromRequestMapping((Annotated)methodAccess);
            String returnDescription = ContextMetaBuilder.getReturnDescriptionFromRequestMapping((Annotated)methodAccess);
            String summary = ContextMetaBuilder.getSummaryFromRequestMapping((Annotated)methodAccess);
            int code = ContextMetaBuilder.getCodeFromRequestMapping((Annotated)methodAccess);
            List<RequestMethod> requestMethods = ContextMetaBuilder.getRequestMethodsByAnnotated((Annotated)methodAccess);
            ServiceMethodMetaBuilder serviceMethodMetaBuilder = ServiceMethodMetaBuilder.serviceMethodMetaBuilder();
            serviceMethodMetaBuilder.setMethodAccess(methodAccess);
            serviceMethodMetaBuilder.setDescription(description);
            serviceMethodMetaBuilder.setSummary(summary);
            serviceMethodMetaBuilder.setReturnDescription(returnDescription);
            serviceMethodMetaBuilder.setResponseCode(code);
            for (String path : requestPaths) {
                CallType callType = path.contains("{") ? CallType.ADDRESS_WITH_PATH_PARAMS : CallType.ADDRESS;
                RequestMetaBuilder requestMetaBuilder = new RequestMetaBuilder();
                requestMetaBuilder.addParameters(rootPath, servicePath, path, methodAccess);
                requestMetaBuilder.setCallType(callType).setRequestURI(path).setRequestMethods(requestMethods);
                serviceMethodMetaBuilder.addRequestEndpoint(requestMetaBuilder.build());
            }
            this.addMethod(serviceMethodMetaBuilder.build());
        }
        return this;
    }
}

