/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.meta.builder;

import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.qbit.jsend.JSendResponse;
import io.advantageous.qbit.meta.RequestMeta;
import io.advantageous.qbit.meta.ServiceMethodMeta;
import io.advantageous.qbit.meta.builder.GenericReturnType;
import io.advantageous.qbit.reactive.Callback;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ServiceMethodMetaBuilder {
    private List<RequestMeta> requestEndpoints = new ArrayList<RequestMeta>();
    private MethodAccess methodAccess;
    private String name;
    private String address;
    private TypeType returnTypeEnum;
    private List<TypeType> paramTypes;
    private boolean hasCallBack;
    private GenericReturnType genericReturnType = GenericReturnType.NONE;
    private Class<?> returnType;
    private Class<?> returnTypeComponent;
    private Class<?> returnTypeComponentKey;
    private Class<?> returnTypeComponentValue;
    private boolean hasReturn;
    private String description;
    private String summary;
    private String returnDescription;
    private int responseCode;

    public String getDescription() {
        return this.description;
    }

    public ServiceMethodMetaBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public static ServiceMethodMetaBuilder serviceMethodMetaBuilder() {
        return new ServiceMethodMetaBuilder();
    }

    public String getAddress() {
        return this.address;
    }

    public ServiceMethodMetaBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public List<RequestMeta> getRequestEndpoints() {
        return this.requestEndpoints;
    }

    public ServiceMethodMetaBuilder setRequestEndpoints(List<RequestMeta> requestEndpoints) {
        this.requestEndpoints = requestEndpoints;
        return this;
    }

    public ServiceMethodMetaBuilder addRequestEndpoint(RequestMeta requestEndpoint) {
        this.requestEndpoints.add(requestEndpoint);
        return this;
    }

    public ServiceMethodMetaBuilder addRequestEndpoint(RequestMeta ... requestEndpointArray) {
        Collections.addAll(this.requestEndpoints, requestEndpointArray);
        return this;
    }

    public MethodAccess getMethodAccess() {
        return this.methodAccess;
    }

    public ServiceMethodMetaBuilder setMethodAccess(MethodAccess methodAccess) {
        this.methodAccess = methodAccess;
        return this;
    }

    public String getName() {
        if (this.name == null && this.methodAccess != null) {
            this.name = this.methodAccess.name();
        }
        return this.name;
    }

    public ServiceMethodMetaBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public TypeType getReturnTypeEnum() {
        return this.returnTypeEnum;
    }

    public ServiceMethodMetaBuilder setReturnTypeEnum(TypeType returnTypeEnum) {
        this.returnTypeEnum = returnTypeEnum;
        return this;
    }

    public List<TypeType> getParamTypes() {
        return this.paramTypes;
    }

    public ServiceMethodMetaBuilder setParamTypes(List<TypeType> paramTypes) {
        this.paramTypes = paramTypes;
        return this;
    }

    public ServiceMethodMeta build() {
        if (this.methodAccess != null) {
            this.setHasCallBack(this.detectCallback());
            this.deduceReturnTypes();
            return new ServiceMethodMeta(this.isHasReturn(), this.getMethodAccess(), this.getName(), this.getRequestEndpoints(), this.getReturnTypeEnum(), this.getParamTypes(), this.hasCallback(), this.getGenericReturnType(), this.getReturnType(), this.getReturnTypeComponent(), this.getReturnTypeComponentKey(), this.getReturnTypeComponentValue(), this.getDescription(), this.getSummary(), this.getReturnDescription(), this.getResponseCode());
        }
        return new ServiceMethodMeta(this.getName(), this.getRequestEndpoints(), this.getReturnTypeEnum(), this.getParamTypes());
    }

    private void deduceReturnTypes() {
        if (this.hasCallback()) {
            this.deduceReturnInfoFromCallbackArg();
        } else {
            this.returnType = this.methodAccess.returnType();
            this.returnTypeEnum = TypeType.getType(this.returnType);
            if (Collection.class.isAssignableFrom(this.returnType)) {
                this.genericReturnType = GenericReturnType.COLLECTION;
                ParameterizedType genericReturnType = (ParameterizedType)this.methodAccess.method().getGenericReturnType();
                this.returnTypeComponent = (Class)genericReturnType.getActualTypeArguments()[0];
            } else if (Map.class.isAssignableFrom(this.returnType)) {
                this.genericReturnType = GenericReturnType.MAP;
                ParameterizedType genericReturnType = (ParameterizedType)this.methodAccess.method().getGenericReturnType();
                this.returnTypeComponentKey = (Class)genericReturnType.getActualTypeArguments()[0];
                this.returnTypeComponentValue = (Class)genericReturnType.getActualTypeArguments()[1];
            } else if (Optional.class.isAssignableFrom(this.returnType)) {
                this.genericReturnType = GenericReturnType.OPTIONAL;
                ParameterizedType genericReturnType = (ParameterizedType)this.methodAccess.method().getGenericReturnType();
                this.returnTypeComponent = (Class)genericReturnType.getActualTypeArguments()[0];
            } else if (JSendResponse.class.isAssignableFrom(this.returnType)) {
                ParameterizedType jsendGenericReturnType;
                this.genericReturnType = GenericReturnType.JSEND;
                ParameterizedType genericReturnType = (ParameterizedType)this.methodAccess.method().getGenericReturnType();
                Type type = genericReturnType.getActualTypeArguments()[0];
                if (type instanceof Class) {
                    this.returnTypeComponent = (Class)type;
                    this.genericReturnType = GenericReturnType.JSEND;
                } else if (type instanceof ParameterizedType && (jsendGenericReturnType = (ParameterizedType)type).getRawType() instanceof Class) {
                    Class rawType = (Class)jsendGenericReturnType.getRawType();
                    if (Collection.class.isAssignableFrom(rawType) || rawType.isArray()) {
                        this.genericReturnType = GenericReturnType.JSEND_ARRAY;
                        Type componentType = jsendGenericReturnType.getActualTypeArguments()[0];
                        if (componentType instanceof Class) {
                            this.returnTypeComponent = (Class)componentType;
                        }
                    } else if (Map.class.isAssignableFrom(rawType)) {
                        this.genericReturnType = GenericReturnType.JSEND_MAP;
                        Type componentKey = jsendGenericReturnType.getActualTypeArguments()[0];
                        if (componentKey instanceof Class) {
                            this.returnTypeComponentKey = (Class)componentKey;
                        }
                        this.genericReturnType = GenericReturnType.JSEND_MAP;
                        Type componentValue = jsendGenericReturnType.getActualTypeArguments()[0];
                        if (componentValue instanceof Class) {
                            this.returnTypeComponentValue = (Class)componentValue;
                        }
                    }
                }
            } else if (this.returnType.isArray()) {
                this.genericReturnType = GenericReturnType.ARRAY;
                this.returnTypeComponent = this.returnType.getComponentType();
            }
        }
        if (this.returnType != Void.TYPE && this.returnType != Void.class) {
            this.hasReturn = true;
        }
    }

    private void deduceReturnInfoFromCallbackArg() {
        Type[] genericParameterTypes = this.methodAccess.method().getGenericParameterTypes();
        Type callback = genericParameterTypes[0];
        if (callback instanceof ParameterizedType) {
            Type callbackReturn = ((ParameterizedType)callback).getActualTypeArguments()[0];
            if (callbackReturn instanceof ParameterizedType) {
                Class containerType = (Class)((ParameterizedType)callbackReturn).getRawType();
                this.returnTypeEnum = TypeType.getType((Class)containerType);
                this.returnType = containerType;
                if (Collection.class.isAssignableFrom(containerType)) {
                    this.genericReturnType = GenericReturnType.COLLECTION;
                    this.returnTypeComponent = (Class)((ParameterizedType)callbackReturn).getActualTypeArguments()[0];
                } else if (Map.class.isAssignableFrom(containerType)) {
                    this.genericReturnType = GenericReturnType.MAP;
                    this.returnTypeComponentKey = (Class)((ParameterizedType)callbackReturn).getActualTypeArguments()[0];
                    this.returnTypeComponentValue = (Class)((ParameterizedType)callbackReturn).getActualTypeArguments()[1];
                } else if (Optional.class.isAssignableFrom(containerType)) {
                    this.genericReturnType = GenericReturnType.OPTIONAL;
                    this.returnTypeComponent = (Class)((ParameterizedType)callbackReturn).getActualTypeArguments()[0];
                } else if (JSendResponse.class.isAssignableFrom(containerType)) {
                    ParameterizedType jsendGenericReturnType;
                    Type returnTypeForComponent = ((ParameterizedType)callbackReturn).getActualTypeArguments()[0];
                    if (returnTypeForComponent instanceof Class) {
                        this.returnTypeComponent = (Class)returnTypeForComponent;
                        this.genericReturnType = GenericReturnType.JSEND;
                    } else if (returnTypeForComponent instanceof ParameterizedType && (jsendGenericReturnType = (ParameterizedType)returnTypeForComponent).getRawType() instanceof Class) {
                        Class rawType = (Class)jsendGenericReturnType.getRawType();
                        if (Collection.class.isAssignableFrom(rawType) || rawType.isArray()) {
                            this.genericReturnType = GenericReturnType.JSEND_ARRAY;
                            Type componentType = jsendGenericReturnType.getActualTypeArguments()[0];
                            if (componentType instanceof Class) {
                                this.returnTypeComponent = (Class)componentType;
                            }
                        } else if (Map.class.isAssignableFrom(rawType)) {
                            this.genericReturnType = GenericReturnType.JSEND_MAP;
                            Type componentKey = jsendGenericReturnType.getActualTypeArguments()[0];
                            if (componentKey instanceof Class) {
                                this.returnTypeComponentKey = (Class)componentKey;
                            }
                            this.genericReturnType = GenericReturnType.JSEND_MAP;
                            Type componentValue = jsendGenericReturnType.getActualTypeArguments()[0];
                            if (componentValue instanceof Class) {
                                this.returnTypeComponentValue = (Class)componentValue;
                            }
                        }
                    }
                }
            } else if (callbackReturn instanceof Class) {
                this.returnType = (Class)callbackReturn;
                if (this.returnType.isArray()) {
                    this.genericReturnType = GenericReturnType.ARRAY;
                }
                this.returnTypeEnum = TypeType.getType(this.returnType);
            }
        }
    }

    private boolean detectCallback() {
        boolean hasCallback = false;
        Class[] classes = this.methodAccess.parameterTypes();
        if (classes.length > 0 && classes[0] == Callback.class) {
            hasCallback = true;
        }
        return hasCallback;
    }

    public ServiceMethodMetaBuilder setHasCallBack(boolean hasCallBack) {
        this.hasCallBack = hasCallBack;
        return this;
    }

    public boolean isHasCallBack() {
        return this.hasCallBack;
    }

    public boolean hasCallback() {
        return this.hasCallBack;
    }

    public boolean isReturnCollection() {
        return this.genericReturnType == GenericReturnType.COLLECTION;
    }

    public ServiceMethodMetaBuilder setReturnCollection(boolean returnCollection) {
        this.genericReturnType = GenericReturnType.COLLECTION;
        return this;
    }

    public boolean isReturnMap() {
        return this.genericReturnType == GenericReturnType.MAP;
    }

    public ServiceMethodMetaBuilder setReturnMap(boolean returnMap) {
        this.genericReturnType = GenericReturnType.MAP;
        return this;
    }

    public boolean isReturnArray() {
        return this.genericReturnType == GenericReturnType.ARRAY;
    }

    public ServiceMethodMetaBuilder setReturnArray(boolean returnArray) {
        this.genericReturnType = GenericReturnType.ARRAY;
        return this;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public ServiceMethodMetaBuilder setReturnType(Class<?> returnType) {
        this.returnType = returnType;
        return this;
    }

    public Class<?> getReturnTypeComponent() {
        return this.returnTypeComponent;
    }

    public ServiceMethodMetaBuilder setReturnTypeComponent(Class<?> returnTypeComponent) {
        this.returnTypeComponent = returnTypeComponent;
        return this;
    }

    public Class<?> getReturnTypeComponentKey() {
        return this.returnTypeComponentKey;
    }

    public ServiceMethodMetaBuilder setReturnTypeComponentKey(Class<?> returnTypeComponentKey) {
        this.returnTypeComponentKey = returnTypeComponentKey;
        return this;
    }

    public Class<?> getReturnTypeComponentValue() {
        return this.returnTypeComponentValue;
    }

    public ServiceMethodMetaBuilder setReturnTypeComponentValue(Class<?> returnTypeComponentValue) {
        this.returnTypeComponentValue = returnTypeComponentValue;
        return this;
    }

    public boolean isHasReturn() {
        return this.hasReturn;
    }

    public ServiceMethodMetaBuilder setHasReturn(boolean hasReturn) {
        this.hasReturn = hasReturn;
        return this;
    }

    public ServiceMethodMetaBuilder setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public ServiceMethodMetaBuilder setReturnDescription(String returnDescription) {
        this.returnDescription = returnDescription;
        return this;
    }

    public String getReturnDescription() {
        return this.returnDescription;
    }

    public GenericReturnType getGenericReturnType() {
        return this.genericReturnType;
    }

    public ServiceMethodMetaBuilder setGenericReturnType(GenericReturnType genericReturnType) {
        this.genericReturnType = genericReturnType;
        return this;
    }

    public ServiceMethodMetaBuilder setResponseCode(int responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public int getResponseCode() {
        return this.responseCode;
    }
}

