/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.meta.provider;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.StringScanner;
import io.advantageous.qbit.annotation.RequestMethod;
import io.advantageous.qbit.meta.CallType;
import io.advantageous.qbit.meta.ContextMeta;
import io.advantageous.qbit.meta.RequestMeta;
import io.advantageous.qbit.meta.RequestMetaData;
import io.advantageous.qbit.meta.ServiceMeta;
import io.advantageous.qbit.meta.ServiceMethodMeta;
import io.advantageous.qbit.meta.provider.MetaDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardMetaDataProvider
implements MetaDataProvider {
    private final Map<String, RequestMetaData> metaDataMap = new ConcurrentHashMap<String, RequestMetaData>(100);
    private final NavigableMap<String, NavigableMap<Integer, RequestMetaData>> treeMap = new TreeMap<String, NavigableMap<Integer, RequestMetaData>>();
    private final RequestMethod httpRequestMethod;
    private final Logger logger = LoggerFactory.getLogger(StandardMetaDataProvider.class);
    private final boolean debug = this.logger.isDebugEnabled();
    private final String rootURI;

    public StandardMetaDataProvider(ContextMeta context, RequestMethod method) {
        this.httpRequestMethod = method;
        this.rootURI = context.getRootURI();
        context.getServices().forEach(service -> this.addService(context, (ServiceMeta)service));
    }

    private void addService(ContextMeta context, ServiceMeta service) {
        service.getMethods().forEach(method -> this.addMethod(context, service, (ServiceMethodMeta)method));
    }

    private void addMethod(ContextMeta context, ServiceMeta service, ServiceMethodMeta method) {
        method.getRequestEndpoints().forEach(requestMeta -> this.addRequest(context, service, method, (RequestMeta)requestMeta));
    }

    private void addRequest(ContextMeta context, ServiceMeta service, ServiceMethodMeta method, RequestMeta requestMeta) {
        service.getRequestPaths().forEach(path -> this.addEndPoint(context, service, method, requestMeta, (String)path));
    }

    private void addEndPoint(ContextMeta context, ServiceMeta service, ServiceMethodMeta method, RequestMeta requestMeta, String servicePath) {
        if (!requestMeta.getRequestMethods().contains((Object)this.httpRequestMethod)) {
            return;
        }
        if (requestMeta.getCallType() == CallType.ADDRESS) {
            String requestPath = requestMeta.getRequestURI();
            String path = Str.join((char)'/', (String[])new String[]{context.getRootURI(), servicePath, requestPath}).replace("//", "/");
            this.addRequestEndPointUsingPath(context, service, method, requestMeta, path.toLowerCase(), requestMeta.getRequestURI(), servicePath);
        } else if (requestMeta.getCallType() == CallType.ADDRESS_WITH_PATH_PARAMS) {
            String requestPath = StringScanner.substringBefore((String)requestMeta.getRequestURI(), (String)"{");
            String path = Str.join((char)'/', (String[])new String[]{context.getRootURI(), servicePath, requestPath}).replace("//", "/");
            this.addRequestEndPointUsingPath(context, service, method, requestMeta, path.toLowerCase(), requestMeta.getRequestURI(), servicePath);
        }
    }

    private void addRequestEndPointUsingPath(ContextMeta context, ServiceMeta service, ServiceMethodMeta method, RequestMeta requestMeta, String path, String requestURI, String servicePath) {
        RequestMetaData metaData = new RequestMetaData(path, context, requestMeta, method, service);
        if (requestMeta.getCallType() == CallType.ADDRESS) {
            this.metaDataMap.put(path, metaData);
        } else {
            TreeMap<Integer, RequestMetaData> map = (TreeMap<Integer, RequestMetaData>)this.treeMap.get(path);
            if (map == null) {
                map = new TreeMap<Integer, RequestMetaData>();
                this.treeMap.put(path, map);
            }
            int count = Str.split((String)(servicePath + requestURI), (char)'/').length - 1;
            map.put(count, metaData);
        }
    }

    private RequestMetaData doGet(String path) {
        RequestMetaData requestMetaData = this.metaDataMap.get(path);
        if (requestMetaData == null) {
            Map.Entry<String, NavigableMap<Integer, RequestMetaData>> uriParamNumMapEntry = this.treeMap.lowerEntry(path);
            if (uriParamNumMapEntry == null) {
                return null;
            }
            String requestURI = StringScanner.substringAfter((String)path, (String)this.rootURI);
            int count = Str.split((String)requestURI, (char)'/').length - 1;
            NavigableMap<Integer, RequestMetaData> uriParamMap = uriParamNumMapEntry.getValue();
            requestMetaData = (RequestMetaData)uriParamMap.get(count);
            if (requestMetaData != null && path.startsWith(requestMetaData.getPath())) {
                return requestMetaData;
            }
            return null;
        }
        return requestMetaData;
    }

    @Override
    public RequestMetaData get(String path) {
        RequestMetaData requestMetaData = this.doGet(path);
        if (requestMetaData == null) {
            requestMetaData = this.doGet(path.toLowerCase());
        }
        if (this.debug && requestMetaData == null) {
            this.metaDataMap.keySet().forEach(mappedPath -> this.logger.debug("Path not found path {}, mapped path {}", (Object)path, mappedPath));
        }
        return requestMetaData;
    }

    public List<String> getPaths() {
        return new ArrayList<String>(this.metaDataMap.keySet());
    }
}

