/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.meta.transformer;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.reflection.MapObjectConversion;
import io.advantageous.qbit.Factory;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.annotation.RequestMethod;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.json.JsonMapper;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.MethodCallBuilder;
import io.advantageous.qbit.meta.ParameterMeta;
import io.advantageous.qbit.meta.RequestMetaData;
import io.advantageous.qbit.meta.params.BodyArrayParam;
import io.advantageous.qbit.meta.params.BodyParam;
import io.advantageous.qbit.meta.params.NamedParam;
import io.advantageous.qbit.meta.params.ParamType;
import io.advantageous.qbit.meta.params.URINamedParam;
import io.advantageous.qbit.meta.params.URIPositionalParam;
import io.advantageous.qbit.meta.provider.StandardMetaDataProvider;
import io.advantageous.qbit.meta.transformer.RequestTransformer;
import io.advantageous.qbit.reactive.Callback;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRequestTransformer
implements RequestTransformer {
    private final Logger logger = LoggerFactory.getLogger(StandardRequestTransformer.class);
    private final boolean debug = this.logger.isDebugEnabled();
    private final Map<RequestMethod, StandardMetaDataProvider> metaDataProviderMap;
    private final Factory factory = QBit.factory();
    protected final ThreadLocal<JsonMapper> jsonMapper = new ThreadLocal<JsonMapper>(){

        @Override
        protected JsonMapper initialValue() {
            return StandardRequestTransformer.this.factory.createJsonMapper();
        }
    };

    public StandardRequestTransformer(Map<RequestMethod, StandardMetaDataProvider> metaDataProviderMap) {
        this.metaDataProviderMap = metaDataProviderMap;
    }

    private final String decodeURLEncoding(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    @Override
    public MethodCall<Object> transform(HttpRequest request, List<String> errorsList) {
        StandardMetaDataProvider standardMetaDataProvider = this.metaDataProviderMap.get((Object)RequestMethod.valueOf(request.getMethod()));
        RequestMetaData metaData = standardMetaDataProvider.get(request.address());
        MethodCallBuilder methodCallBuilder = new MethodCallBuilder();
        methodCallBuilder.setAddress(request.address());
        methodCallBuilder.setOriginatingRequest(request);
        if (metaData == null) {
            errorsList.add("Unable to find handler");
            if (this.debug) {
                standardMetaDataProvider.getPaths().forEach(mappedPath -> this.logger.debug("Path not found path {}, mapped path {}", (Object)request.address(), mappedPath));
            }
            return null;
        }
        methodCallBuilder.setName(metaData.getMethod().getName());
        methodCallBuilder.setObjectName(metaData.getService().getName());
        List<ParameterMeta> parameters = metaData.getRequest().getParameters();
        ArrayList args = new ArrayList(parameters.size());
        block10: for (ParameterMeta parameterMeta : parameters) {
            Map<?, ?> value;
            ParamType paramType = parameterMeta.getParam().getParamType();
            ParamType paramType2 = paramType = paramType == null ? ParamType.BODY : paramType;
            if (parameterMeta.getClassType() == Callback.class) continue;
            switch (paramType) {
                case REQUEST: {
                    NamedParam namedParam = (NamedParam)parameterMeta.getParam();
                    value = request.params().get(namedParam.getName());
                    if (namedParam.isRequired() && Str.isEmpty((Object)value)) {
                        errorsList.add(Str.sputs((Object[])new Object[]{"Unable to find required request param", namedParam.getName()}));
                        break block10;
                    }
                    if (Str.isEmpty((Object)value)) {
                        value = namedParam.getDefaultValue();
                    }
                    value = value != null ? this.decodeURLEncoding(value.toString()) : value;
                    break;
                }
                case HEADER: {
                    NamedParam namedParam = (NamedParam)parameterMeta.getParam();
                    value = request.headers().get(namedParam.getName());
                    if (namedParam.isRequired() && Str.isEmpty((Object)value)) {
                        errorsList.add(Str.sputs((Object[])new Object[]{"Unable to find required header param", namedParam.getName()}));
                        break block10;
                    }
                    if (Str.isEmpty((Object)value)) {
                        value = namedParam.getDefaultValue();
                    }
                    value = value != null ? this.decodeURLEncoding(value.toString()) : value;
                    break;
                }
                case PATH_BY_NAME: {
                    URINamedParam uriNamedParam = (URINamedParam)parameterMeta.getParam();
                    String[] split = Str.split((String)request.address(), (char)'/');
                    if (uriNamedParam.getIndexIntoURI() >= split.length && uriNamedParam.isRequired()) {
                        errorsList.add(Str.sputs((Object[])new Object[]{"Unable to find required path param", uriNamedParam.getName()}));
                        break block10;
                    }
                    value = split[uriNamedParam.getIndexIntoURI()];
                    if (uriNamedParam.isRequired() && Str.isEmpty((Object)value)) {
                        errorsList.add(Str.sputs((Object[])new Object[]{"Unable to find required path param", uriNamedParam.getName()}));
                        break block10;
                    }
                    if (Str.isEmpty((Object)value)) {
                        value = uriNamedParam.getDefaultValue();
                    }
                    value = value != null ? this.decodeURLEncoding(value.toString()) : value;
                    break;
                }
                case PATH_BY_POSITION: {
                    URIPositionalParam positionalParam = (URIPositionalParam)parameterMeta.getParam();
                    String[] pathSplit = Str.split((String)request.address(), (char)'/');
                    if (positionalParam.getIndexIntoURI() >= pathSplit.length && positionalParam.isRequired()) {
                        errorsList.add(Str.sputs((Object[])new Object[]{"Unable to find required path param", positionalParam.getIndexIntoURI()}));
                        break block10;
                    }
                    value = pathSplit[positionalParam.getIndexIntoURI()];
                    if (positionalParam.isRequired() && Str.isEmpty((Object)value)) {
                        errorsList.add(Str.sputs((Object[])new Object[]{"Unable to find required path param", positionalParam.getIndexIntoURI()}));
                        break block10;
                    }
                    if (Str.isEmpty((Object)value)) {
                        value = positionalParam.getDefaultValue();
                    }
                    value = value != null ? this.decodeURLEncoding(value.toString()) : value;
                    break;
                }
                case BODY: {
                    byte[] bytes;
                    BodyParam bodyParam = (BodyParam)parameterMeta.getParam();
                    value = request.body();
                    String contentType = request.getContentType();
                    if (this.isJsonContent(contentType)) {
                        if (value instanceof byte[]) {
                            bytes = (byte[])value;
                            value = new String(bytes, StandardCharsets.UTF_8);
                        }
                        if (bodyParam.isRequired() && Str.isEmpty((Object)value)) {
                            errorsList.add("Unable to find body");
                            break block10;
                        }
                        if (Str.isEmpty((Object)value)) {
                            value = bodyParam.getDefaultValue();
                        }
                        try {
                            if (parameterMeta.isArray() || parameterMeta.isCollection()) {
                                value = this.jsonMapper.get().fromJsonArray(value.toString(), parameterMeta.getComponentClass());
                                break;
                            }
                            if (parameterMeta.isMap()) {
                                value = this.jsonMapper.get().fromJsonMap(value.toString(), parameterMeta.getComponentClassKey(), parameterMeta.getComponentClassValue());
                                break;
                            }
                            value = this.jsonMapper.get().fromJson(value.toString(), parameterMeta.getClassType());
                        }
                        catch (Exception exception) {
                            errorsList.add("Unable to JSON parse body :: " + exception.getMessage());
                            this.logger.warn("Unable to parse object", (Throwable)exception);
                        }
                        break;
                    }
                    if (!parameterMeta.isString() || !(value instanceof byte[])) break;
                    bytes = (byte[])value;
                    value = new String(bytes, StandardCharsets.UTF_8);
                    break;
                }
                case BODY_BY_POSITION: {
                    List list;
                    Object o;
                    BodyArrayParam bodyArrayParam = (BodyArrayParam)parameterMeta.getParam();
                    value = request.body();
                    if (value instanceof byte[]) {
                        byte[] bytes = (byte[])value;
                        value = new String(bytes, StandardCharsets.UTF_8);
                    }
                    if (bodyArrayParam.isRequired() && Str.isEmpty((Object)value)) {
                        errorsList.add("Unable to find body");
                        break block10;
                    }
                    if (Str.isEmpty((Object)value)) {
                        value = bodyArrayParam.getDefaultValue();
                    }
                    if (!((value = this.jsonMapper.get().fromJson(value.toString())) instanceof List) || !((o = (list = (List)((Object)value)).get(bodyArrayParam.getPosition())) instanceof Map)) break;
                    value = MapObjectConversion.fromMap((Map)((Map)o), parameterMeta.getClassType());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            args.add((List<?>)((Object)value));
        }
        methodCallBuilder.setBody(args);
        return methodCallBuilder.build();
    }

    private boolean isJsonContent(String contentType) {
        return Str.isEmpty((String)contentType) || contentType.equals("application/json") || contentType.equals("application/json;charset=utf-8") || contentType.startsWith("application/json");
    }
}

