/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.network.impl;

import io.advantageous.boon.core.Sys;
import io.advantageous.qbit.network.NetSocket;
import io.advantageous.qbit.network.NetworkSender;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class NetSocketBase
implements NetSocket {
    private final String remoteAddress;
    private final String uri;
    private final boolean binary;
    private final AtomicBoolean open = new AtomicBoolean();
    private NetworkSender networkSender;
    private Consumer<String> textMessageConsumer = text -> {};
    private Consumer<byte[]> binaryMessageConsumer = bytes -> {};
    private Consumer<Void> closeConsumer = aVoid -> {};
    private Consumer<Void> openConsumer = aVoid -> {};
    private Consumer<Exception> errorConsumer = error -> LoggerFactory.getLogger(NetSocketBase.class).error(error.getMessage(), (Throwable)error);

    public NetSocketBase(String remoteAddress, String uri, boolean open, boolean binary, NetworkSender networkSender) {
        this.remoteAddress = remoteAddress;
        this.uri = uri;
        this.open.set(open);
        this.binary = binary;
        this.networkSender = networkSender;
    }

    @Override
    public String remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public boolean isBinary() {
        return this.binary;
    }

    @Override
    public void onTextMessage(String message) {
        this.textMessageConsumer.accept(message);
    }

    @Override
    public void onBinaryMessage(byte[] bytes) {
        this.binaryMessageConsumer.accept(bytes);
    }

    @Override
    public void onClose() {
        this.open.set(false);
        this.closeConsumer.accept(null);
    }

    @Override
    public void onOpen() {
        this.open.set(true);
        this.openConsumer.accept(null);
    }

    @Override
    public void onError(Exception exception) {
        this.open.set(false);
        this.errorConsumer.accept(exception);
    }

    @Override
    public void sendText(String text) {
        try {
            this.networkSender.sendText(text);
        }
        catch (Exception ex) {
            this.onError(ex);
        }
    }

    @Override
    public void sendBinary(byte[] bytes) {
        try {
            this.networkSender.sendBytes(bytes);
        }
        catch (Exception ex) {
            this.onError(ex);
        }
    }

    @Override
    public boolean isClosed() {
        return !this.open.get();
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void setTextMessageConsumer(Consumer<String> textMessageConsumer) {
        this.textMessageConsumer = textMessageConsumer;
    }

    @Override
    public void setBinaryMessageConsumer(Consumer<byte[]> binaryMessageConsumer) {
        this.binaryMessageConsumer = binaryMessageConsumer;
    }

    @Override
    public void setCloseConsumer(Consumer<Void> closeConsumer) {
        this.closeConsumer = closeConsumer;
    }

    @Override
    public void setOpenConsumer(Consumer<Void> openConsumer) {
        this.openConsumer = openConsumer;
    }

    @Override
    public void setErrorConsumer(Consumer<Exception> exceptionConsumer) {
        this.errorConsumer = exceptionConsumer;
    }

    @Override
    public void close() {
        try {
            this.networkSender.close();
        }
        catch (Exception ex) {
            this.onError(ex);
        }
    }

    @Override
    public void open() {
        try {
            this.networkSender.open(this);
        }
        catch (Exception ex) {
            this.onError(ex);
        }
    }

    @Override
    public void openAndWait() {
        this.open();
        int count = 5;
        while (!this.open.get()) {
            Sys.sleep((long)50L);
            if (--count > 0) continue;
            throw new IllegalStateException("Unable to open WebSocket connection");
        }
    }

    public void setSender(NetworkSender networkSender) {
        this.networkSender = networkSender;
    }
}

