/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.proxy;

import io.advantageous.qbit.http.client.HttpClientBuilder;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.http.request.HttpRequestBuilder;
import io.advantageous.qbit.proxy.ProxyService;
import io.advantageous.qbit.proxy.ProxyServiceImpl;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.reactive.ReactorBuilder;
import io.advantageous.qbit.service.ServiceBuilder;
import io.advantageous.qbit.time.Duration;
import io.advantageous.qbit.util.Timer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ProxyBuilder {
    private Reactor reactor;
    private Timer timer;
    private HttpClientBuilder httpClientBuilder;
    private Consumer<HttpRequestBuilder> beforeSend;
    private Consumer<Exception> errorHandler;
    private Predicate<HttpRequest> httpClientRequestPredicate;
    private Duration checkClientDuration = Duration.MINUTES.units(10L);
    private HttpRequestBuilder pingBuilder;
    private boolean trackTimeOuts;
    private Duration timeOutInterval = Duration.SECONDS.units(180L);
    private ServiceBuilder serviceBuilder;

    public ServiceBuilder getServiceBuilder() {
        if (this.serviceBuilder == null) {
            this.serviceBuilder = ServiceBuilder.serviceBuilder();
        }
        return this.serviceBuilder;
    }

    public Reactor getReactor() {
        if (this.reactor == null) {
            this.reactor = ReactorBuilder.reactorBuilder().build();
        }
        return this.reactor;
    }

    public ProxyBuilder setReactor(Reactor reactor) {
        this.reactor = reactor;
        return this;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = Timer.timer();
        }
        return this.timer;
    }

    public ProxyBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder == null) {
            this.httpClientBuilder = HttpClientBuilder.httpClientBuilder().setPipeline(false).setKeepAlive(false).setPoolSize(100);
        }
        return this.httpClientBuilder;
    }

    public ProxyBuilder setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        return this;
    }

    public Consumer<HttpRequestBuilder> getBeforeSend() {
        if (this.beforeSend == null) {
            this.beforeSend = httpRequestBuilder -> {};
        }
        return this.beforeSend;
    }

    public ProxyBuilder setBeforeSend(Consumer<HttpRequestBuilder> beforeSend) {
        this.beforeSend = beforeSend;
        return this;
    }

    public Consumer<Exception> getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = e -> {};
        }
        return this.errorHandler;
    }

    public ProxyBuilder setErrorHandler(Consumer<Exception> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public Predicate<HttpRequest> getHttpClientRequestPredicate() {
        if (this.httpClientRequestPredicate == null) {
            this.httpClientRequestPredicate = request -> true;
        }
        return this.httpClientRequestPredicate;
    }

    public ProxyBuilder setHttpClientRequestPredicate(Predicate<HttpRequest> httpClientRequestPredicate) {
        this.httpClientRequestPredicate = httpClientRequestPredicate;
        return this;
    }

    public Duration getCheckClientDuration() {
        return this.checkClientDuration;
    }

    public ProxyBuilder setCheckClientDuration(Duration checkClientDuration) {
        this.checkClientDuration = checkClientDuration;
        return this;
    }

    public HttpRequestBuilder getPingBuilder() {
        return this.pingBuilder;
    }

    public ProxyBuilder setPingBuilder(HttpRequestBuilder pingBuilder) {
        this.pingBuilder = pingBuilder;
        return this;
    }

    public boolean isTrackTimeOuts() {
        return this.trackTimeOuts;
    }

    public ProxyBuilder setTrackTimeOuts(boolean trackTimeOuts) {
        this.trackTimeOuts = trackTimeOuts;
        return this;
    }

    public Duration getTimeOutInterval() {
        return this.timeOutInterval;
    }

    public ProxyBuilder setTimeOutInterval(Duration timeOutInterval) {
        this.timeOutInterval = timeOutInterval;
        return this;
    }

    public ProxyService build() {
        return new ProxyServiceImpl(this.getReactor(), this.getTimer(), this.getHttpClientBuilder(), this.getBeforeSend(), this.getErrorHandler(), this.getHttpClientRequestPredicate(), this.getCheckClientDuration(), this.pingBuilder == null ? Optional.empty() : Optional.of(this.pingBuilder), this.isTrackTimeOuts(), this.getTimeOutInterval());
    }

    public ProxyService buildProxy() {
        return this.getServiceBuilder().setServiceObject(this.build()).buildAndStart().createProxyWithAutoFlush(ProxyService.class, Duration.HUNDRED_MILLIS);
    }

    public static ProxyBuilder proxyBuilder() {
        return new ProxyBuilder();
    }
}

