/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.proxy;

import io.advantageous.qbit.annotation.QueueCallback;
import io.advantageous.qbit.annotation.QueueCallbackType;
import io.advantageous.qbit.http.client.HttpClient;
import io.advantageous.qbit.http.client.HttpClientBuilder;
import io.advantageous.qbit.http.client.HttpClientClosedConnectionException;
import io.advantageous.qbit.http.request.HttpBinaryReceiver;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.http.request.HttpRequestBuilder;
import io.advantageous.qbit.proxy.ProxyService;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.time.Duration;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServiceImpl
implements ProxyService {
    private final Reactor reactor;
    private final Timer timer;
    private final HttpClientBuilder httpClientBuilder;
    private final Optional<HttpRequestBuilder> pingBuilder;
    private final long timeOutIntervalMS;
    private final Logger logger = LoggerFactory.getLogger(ProxyServiceImpl.class);
    private final Consumer<HttpRequestBuilder> beforeSend;
    private final Consumer<Exception> errorHandler;
    private final Predicate<HttpRequest> httpClientRequestPredicate;
    private final AtomicInteger errorCount = new AtomicInteger();
    private final AtomicInteger pingCount = new AtomicInteger();
    private final boolean trackTimeOuts;
    private HttpClient backendServiceHttpClient;
    private long time;
    private long lastHttpClientStart;
    private final List<HttpRequestHolder> httpRequestHolderList;

    public ProxyServiceImpl(Reactor reactor, Timer timer, HttpClientBuilder httpClientBuilder, Consumer<HttpRequestBuilder> beforeSend, Consumer<Exception> errorHandler, Predicate<HttpRequest> httpClientRequestPredicate, Duration checkClientDuration, Optional<HttpRequestBuilder> pingBuilder, boolean trackTimeOuts, Duration timeOutInterval) {
        this.reactor = reactor;
        this.timer = timer;
        this.httpClientBuilder = httpClientBuilder;
        this.backendServiceHttpClient = this.httpClientBuilder.buildAndStart();
        this.beforeSend = beforeSend;
        this.errorHandler = errorHandler;
        this.httpClientRequestPredicate = httpClientRequestPredicate;
        this.trackTimeOuts = trackTimeOuts;
        this.reactor.addRepeatingTask(checkClientDuration, this::checkClient);
        this.pingBuilder = pingBuilder;
        if (trackTimeOuts) {
            this.httpRequestHolderList = new ArrayList<HttpRequestHolder>();
            this.timeOutIntervalMS = timeOutInterval.toMillis();
            this.reactor.addRepeatingTask(this.timeOutIntervalMS / 2L, TimeUnit.MILLISECONDS, this::trackTimeouts);
        } else {
            this.httpRequestHolderList = null;
            this.timeOutIntervalMS = -1L;
        }
    }

    private void trackTimeouts() {
        new ArrayList<HttpRequestHolder>(this.httpRequestHolderList).forEach(httpRequestHolder -> {
            if (httpRequestHolder.request.isHandled()) {
                this.httpRequestHolderList.remove(httpRequestHolder);
                return;
            }
            long duration = this.time - httpRequestHolder.startTime;
            if (duration > this.timeOutIntervalMS) {
                httpRequestHolder.request.handled();
                httpRequestHolder.request.getReceiver().timeoutWithMessage(String.format("\"TIMEOUT %s %s %s\"", httpRequestHolder.request.address(), httpRequestHolder.request.getRemoteAddress(), httpRequestHolder.startTime));
                this.httpRequestHolderList.remove(httpRequestHolder);
            }
        });
    }

    private void checkClient() {
        try {
            if (this.errorCount.get() > 0) {
                this.errorCount.set(0);
                if (this.backendServiceHttpClient == null || this.backendServiceHttpClient.isClosed()) {
                    if (this.backendServiceHttpClient != null) {
                        try {
                            this.backendServiceHttpClient.stop();
                        }
                        catch (Exception ex) {
                            this.logger.debug("Was unable to stop the client connection", (Throwable)ex);
                        }
                    }
                    this.backendServiceHttpClient = this.httpClientBuilder.buildAndStart();
                    this.lastHttpClientStart = this.time;
                }
            }
            if (this.pingBuilder.isPresent() && this.backendServiceHttpClient != null) {
                this.pingBuilder.get().setBinaryReceiver((code, contentType, body) -> {
                    if (code >= 200 && code < 299) {
                        this.pingCount.incrementAndGet();
                    } else {
                        this.errorCount.incrementAndGet();
                    }
                }).setErrorHandler(e -> {
                    this.logger.error("Error doing ping operation", (Throwable)e);
                    this.errorCount.incrementAndGet();
                });
                HttpRequest httpRequest = this.pingBuilder.get().build();
                this.backendServiceHttpClient.sendHttpRequest(httpRequest);
            }
        }
        catch (Exception ex) {
            this.errorHandler.accept(ex);
            this.logger.error("Unable to check connection");
        }
    }

    @Override
    public void handleRequest(HttpRequest clientRequest) {
        if (this.trackTimeOuts) {
            this.httpRequestHolderList.add(new HttpRequestHolder(clientRequest, this.time));
        }
        if (this.httpClientRequestPredicate.test(clientRequest)) {
            this.createBackEndRequestPopulateAndForward(clientRequest);
        }
    }

    private void createBackEndRequestPopulateAndForward(final HttpRequest clientRequest) {
        block6: {
            try {
                if (this.backendServiceHttpClient == null) {
                    this.handleHttpClientErrorsForBackend(clientRequest, new HttpClientClosedConnectionException("Not connected"));
                    long timeSinceLastStart = this.time - this.lastHttpClientStart;
                    if (timeSinceLastStart > 10000L) {
                        this.checkClient();
                    }
                    return;
                }
                HttpRequestBuilder httpRequestBuilder = HttpRequestBuilder.httpRequestBuilder().copyRequest(clientRequest).setBinaryReceiver(new HttpBinaryReceiver(){

                    @Override
                    public void response(int code, String contentType, byte[] body, MultiMap<String, String> headers) {
                        ProxyServiceImpl.this.handleBackendClientResponses(clientRequest, code, contentType, body, headers);
                    }

                    @Override
                    public void response(int code, String contentType, byte[] body) {
                        this.response(code, contentType, body, MultiMap.empty());
                    }
                }).setErrorHandler(e -> this.handleHttpClientErrorsForBackend(clientRequest, (Exception)e));
                this.beforeSend.accept(httpRequestBuilder);
                this.backendServiceHttpClient.sendHttpRequest(httpRequestBuilder.build());
            }
            catch (HttpClientClosedConnectionException httpClientClosedConnectionException) {
                this.errorCount.incrementAndGet();
                this.errorHandler.accept(httpClientClosedConnectionException);
                this.logger.error("Unable to forward request", (Throwable)httpClientClosedConnectionException);
                this.handleHttpClientErrorsForBackend(clientRequest, httpClientClosedConnectionException);
                this.backendServiceHttpClient = null;
                long timeSinceLastStart = this.time - this.lastHttpClientStart;
                if (timeSinceLastStart > 10000L) {
                    this.checkClient();
                }
            }
            catch (Exception ex) {
                this.errorCount.incrementAndGet();
                this.errorHandler.accept(ex);
                this.logger.error("Unable to forward request", (Throwable)ex);
                this.handleHttpClientErrorsForBackend(clientRequest, ex);
                long timeSinceLastStart = this.time - this.lastHttpClientStart;
                if (timeSinceLastStart <= 10000L) break block6;
                this.checkClient();
            }
        }
    }

    private void handleHttpClientErrorsForBackend(HttpRequest clientRequest, Exception e) {
        this.errorHandler.accept(e);
        this.errorCount.incrementAndGet();
        String errorMessage = String.format("Unable to make request %s ", clientRequest.address());
        this.logger.error(errorMessage, (Throwable)e);
        if (!clientRequest.isHandled()) {
            clientRequest.handled();
            clientRequest.getReceiver().error(String.format("\"%s\"", errorMessage));
        }
    }

    private void handleBackendClientResponses(HttpRequest clientRequest, int code, String contentType, byte[] body, MultiMap<String, String> headers) {
        if (!clientRequest.isHandled()) {
            clientRequest.handled();
            clientRequest.getReceiver().response(code, contentType, body, headers);
        }
    }

    @QueueCallback(value={QueueCallbackType.EMPTY, QueueCallbackType.IDLE, QueueCallbackType.LIMIT})
    public void process() {
        this.reactor.process();
        this.time = this.timer.time();
    }

    private class HttpRequestHolder {
        final HttpRequest request;
        final long startTime;

        private HttpRequestHolder(HttpRequest request, long startTime) {
            this.request = request;
            this.startTime = startTime;
        }
    }
}

