/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue;

import io.advantageous.qbit.QBit;
import io.advantageous.qbit.concurrent.PeriodicScheduler;
import io.advantageous.qbit.json.JsonMapper;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.ReceiveQueue;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.queue.SendQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class JsonQueue<T>
implements Queue<T> {
    private final Queue<String> queue;
    private final Function<String, T> fromJsonFunction;
    private final Function<T, String> toJsonFunction;

    public static <T> JsonQueue<List<T>> createListQueueWithMapper(Class<T> componentClass, Queue<String> queue, JsonMapper jsonMapper) {
        return new JsonQueue<List<T>>(queue, json -> jsonMapper.fromJsonArray((String)json, componentClass), jsonMapper::toJson);
    }

    public static <T> JsonQueue<List<T>> createListQueue(Class<T> componentClass, Queue<String> queue) {
        JsonMapper jsonMapper = QBit.factory().createJsonMapper();
        return JsonQueue.createListQueueWithMapper(componentClass, queue, jsonMapper);
    }

    public static <K, V> JsonQueue<Map<K, V>> createMapQueueWithMapper(Class<K> mapKeyClass, Class<V> valueKeyClass, Queue<String> queue, JsonMapper jsonMapper) {
        return new JsonQueue<Map<K, V>>(queue, json -> jsonMapper.fromJsonMap((String)json, mapKeyClass, valueKeyClass), jsonMapper::toJson);
    }

    public static <K, V> JsonQueue<Map<K, V>> createMapQueue(Class<K> mapKeyClass, Class<V> valueKeyClass, Queue<String> queue) {
        JsonMapper jsonMapper = QBit.factory().createJsonMapper();
        return JsonQueue.createMapQueueWithMapper(mapKeyClass, valueKeyClass, queue, jsonMapper);
    }

    public JsonQueue(Queue<String> queue, Function<String, T> fromJsonFunction, Function<T, String> toJsonFunction) {
        this.queue = queue;
        this.fromJsonFunction = fromJsonFunction;
        this.toJsonFunction = toJsonFunction;
    }

    public JsonQueue(Class<T> classType, Queue<String> queue, JsonMapper jsonMapper) {
        this(queue, (String json) -> jsonMapper.fromJson((String)json, classType), jsonMapper::toJson);
    }

    public JsonQueue(Class<T> classType, Queue<String> queue) {
        this(classType, queue, QBit.factory().createJsonMapper());
    }

    @Override
    public ReceiveQueue<T> receiveQueue() {
        final ReceiveQueue<String> receiveQueue = this.queue.receiveQueue();
        return new ReceiveQueue<T>(){

            @Override
            public T pollWait() {
                String item = (String)receiveQueue.pollWait();
                return this.getParsedItem(item);
            }

            private T getParsedItem(String item) {
                if (item != null) {
                    return JsonQueue.this.fromJsonFunction.apply(item);
                }
                return null;
            }

            @Override
            public T poll() {
                String item = (String)receiveQueue.pollWait();
                return this.getParsedItem(item);
            }

            @Override
            public T take() {
                String item = (String)receiveQueue.take();
                return this.getParsedItem(item);
            }

            @Override
            public Iterable<T> readBatch(int max) {
                Iterable<String> iterable = receiveQueue.readBatch(max);
                return this.getParsedItems(iterable);
            }

            private Iterable<T> getParsedItems(Iterable<String> iterable) {
                int size = 16;
                if (iterable instanceof List) {
                    size = ((List)iterable).size();
                }
                ArrayList items = new ArrayList(size);
                for (String item : iterable) {
                    items.add(this.getParsedItem(item));
                }
                return items;
            }

            @Override
            public Iterable<T> readBatch() {
                Iterable<String> iterable = receiveQueue.readBatch();
                return this.getParsedItems(iterable);
            }

            @Override
            public void stop() {
                receiveQueue.stop();
            }
        };
    }

    @Override
    public SendQueue<T> sendQueue() {
        SendQueue<String> sendQueue = this.queue.sendQueue();
        return this.createJsonSendQueue(sendQueue);
    }

    private SendQueue<T> createJsonSendQueue(final SendQueue<String> sendQueue) {
        return new SendQueue<T>(){

            @Override
            public boolean send(T item) {
                sendQueue.send(JsonQueue.this.toJsonFunction.apply(item));
                return false;
            }

            @Override
            public void sendAndFlush(T item) {
                sendQueue.sendAndFlush(JsonQueue.this.toJsonFunction.apply(item));
            }

            @Override
            public void sendMany(T ... items) {
                for (Object item : items) {
                    sendQueue.send(JsonQueue.this.toJsonFunction.apply(item));
                }
            }

            @Override
            public void sendBatch(Collection<T> items) {
                for (Object item : items) {
                    sendQueue.send(JsonQueue.this.toJsonFunction.apply(item));
                }
            }

            @Override
            public void sendBatch(Iterable<T> items) {
                for (Object item : items) {
                    sendQueue.send(JsonQueue.this.toJsonFunction.apply(item));
                }
            }

            @Override
            public boolean shouldBatch() {
                return sendQueue.shouldBatch();
            }

            @Override
            public void flushSends() {
                sendQueue.flushSends();
            }

            @Override
            public int size() {
                return sendQueue.size();
            }

            @Override
            public String name() {
                return sendQueue.name();
            }

            @Override
            public void stop() {
                sendQueue.stop();
            }
        };
    }

    @Override
    public SendQueue<T> sendQueueWithAutoFlush(int interval, TimeUnit timeUnit) {
        SendQueue<String> sendQueue = this.queue.sendQueueWithAutoFlush(interval, timeUnit);
        return this.createJsonSendQueue(sendQueue);
    }

    @Override
    public SendQueue<T> sendQueueWithAutoFlush(PeriodicScheduler periodicScheduler, int interval, TimeUnit timeUnit) {
        SendQueue<String> sendQueue = this.queue.sendQueueWithAutoFlush(periodicScheduler, interval, timeUnit);
        return this.createJsonSendQueue(sendQueue);
    }

    @Override
    public void startListener(ReceiveQueueListener<T> listener) {
        this.queue.startListener(item -> listener.receive(this.fromJsonFunction.apply((String)item)));
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean started() {
        return this.queue.started();
    }

    @Override
    public String name() {
        return this.queue.name();
    }

    @Override
    public void stop() {
        this.queue.stop();
    }
}

