/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue;

import io.advantageous.qbit.QBit;
import io.advantageous.qbit.concurrent.PeriodicScheduler;
import io.advantageous.qbit.queue.ReceiveQueue;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.queue.impl.AutoFlushingSendQueue;
import io.advantageous.qbit.service.Stoppable;
import java.util.concurrent.TimeUnit;

public interface Queue<T>
extends Stoppable {
    public ReceiveQueue<T> receiveQueue();

    public SendQueue<T> sendQueue();

    default public SendQueue<T> sendQueueWithAutoFlush(int interval, TimeUnit timeUnit) {
        PeriodicScheduler periodicScheduler = QBit.factory().periodicScheduler();
        return this.sendQueueWithAutoFlush(periodicScheduler, interval, timeUnit);
    }

    default public SendQueue<T> sendQueueWithAutoFlush(PeriodicScheduler periodicScheduler, int interval, TimeUnit timeUnit) {
        SendQueue<T> sendQueue = this.sendQueue();
        return new AutoFlushingSendQueue<T>(sendQueue, periodicScheduler, interval, timeUnit);
    }

    public void startListener(ReceiveQueueListener<T> var1);

    public int size();

    default public boolean started() {
        return true;
    }

    default public String name() {
        return "NO OP";
    }
}

