/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue;

import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.UnableToEnqueueHandler;
import io.advantageous.qbit.queue.impl.AddTimeoutUnableToEnqueueHandler;
import io.advantageous.qbit.queue.impl.BasicQueue;
import io.advantageous.qbit.queue.impl.DefaultUnableToEnqueueHandler;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;

public class QueueBuilder
implements Cloneable {
    public static final String QBIT_QUEUE_BUILDER = "qbit.queue.builder.";
    private int batchSize;
    private int pollWait;
    private int size;
    private int checkEvery;
    private boolean tryTransfer;
    private String name;
    private Class<? extends BlockingQueue> queueClass;
    private boolean checkIfBusy = false;
    private TimeUnit pollTimeUnit = TimeUnit.MILLISECONDS;
    private TimeUnit enqueueTimeoutTimeUnit = null;
    private int enqueueTimeout;
    private UnableToEnqueueHandler unableToEnqueueHandler;

    public UnableToEnqueueHandler getUnableToEnqueueHandler() {
        if (this.unableToEnqueueHandler == null) {
            this.unableToEnqueueHandler = this.enqueueTimeoutTimeUnit == null ? new DefaultUnableToEnqueueHandler() : new AddTimeoutUnableToEnqueueHandler(this.enqueueTimeout, this.enqueueTimeoutTimeUnit);
        }
        return this.unableToEnqueueHandler;
    }

    public QueueBuilder setUnableToEnqueueHandler(UnableToEnqueueHandler unableToEnqueueHandler) {
        this.unableToEnqueueHandler = unableToEnqueueHandler;
        return this;
    }

    public QueueBuilder(PropertyResolver propertyResolver) {
        this.pollWait = propertyResolver.getIntegerProperty("pollWaitMS", 15);
        this.enqueueTimeout = propertyResolver.getIntegerProperty("enqueueTimeoutSeconds", 1000);
        this.batchSize = propertyResolver.getIntegerProperty("batchSize", 10);
        this.checkEvery = propertyResolver.getIntegerProperty("checkEvery", 10);
        this.size = propertyResolver.getIntegerProperty("size", 100000);
        this.checkIfBusy = propertyResolver.getBooleanProperty("checkIfBusy", false);
        this.tryTransfer = propertyResolver.getBooleanProperty("tryTransfer", false);
        this.queueClass = propertyResolver.getGenericPropertyWithDefault("queueClass", ArrayBlockingQueue.class);
    }

    public TimeUnit getEnqueueTimeoutTimeUnit() {
        return this.enqueueTimeoutTimeUnit;
    }

    public QueueBuilder setEnqueueTimeoutTimeUnit(TimeUnit enqueueTimeoutTimeUnit) {
        this.enqueueTimeoutTimeUnit = enqueueTimeoutTimeUnit;
        return this;
    }

    public TimeUnit getPollTimeUnit() {
        return this.pollTimeUnit;
    }

    public QueueBuilder setPollTimeUnit(TimeUnit pollTimeUnit) {
        this.pollTimeUnit = pollTimeUnit;
        return this;
    }

    public int getEnqueueTimeout() {
        return this.enqueueTimeout;
    }

    public QueueBuilder setEnqueueTimeout(int enqueueTimeout) {
        this.enqueueTimeout = enqueueTimeout;
        return this;
    }

    public QueueBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(QBIT_QUEUE_BUILDER));
    }

    public QueueBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(QBIT_QUEUE_BUILDER, properties));
    }

    public static QueueBuilder queueBuilder() {
        return new QueueBuilder();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getCheckEvery() {
        return this.checkEvery;
    }

    public QueueBuilder setCheckEvery(int checkEvery) {
        this.checkEvery = checkEvery;
        this.checkIfBusy = true;
        return this;
    }

    public boolean isTryTransfer() {
        return this.tryTransfer;
    }

    public QueueBuilder setTryTransfer(boolean tryTransfer) {
        this.tryTransfer = tryTransfer;
        return this;
    }

    public Class<? extends BlockingQueue> getQueueClass() {
        return this.queueClass;
    }

    public void setQueueClass(Class<? extends BlockingQueue> queueClass) {
        this.queueClass = queueClass;
    }

    public QueueBuilder setLinkedBlockingQueue() {
        this.queueClass = LinkedBlockingQueue.class;
        return this;
    }

    public QueueBuilder setArrayBlockingQueue() {
        if (this.size == -1) {
            this.size = 100000;
        }
        this.queueClass = ArrayBlockingQueue.class;
        return this;
    }

    public QueueBuilder setLinkTransferQueue() {
        this.size = -1;
        this.batchSize = this.checkEvery * 10;
        this.queueClass = LinkedTransferQueue.class;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public QueueBuilder setSize(int size) {
        this.size = size;
        return this;
    }

    public boolean isCheckIfBusy() {
        return this.checkIfBusy;
    }

    public QueueBuilder setCheckIfBusy(boolean checkIfBusy) {
        this.checkIfBusy = checkIfBusy;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public QueueBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getPollWait() {
        return this.pollWait;
    }

    public QueueBuilder setPollWait(int pollWait) {
        this.pollWait = pollWait;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public QueueBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public <T> Queue<T> build() {
        return new BasicQueue(this.getName(), this.getPollWait(), this.getPollTimeUnit(), this.getBatchSize(), this.getQueueClass(), this.isCheckIfBusy(), this.getSize(), this.getCheckEvery(), this.isTryTransfer(), this.getUnableToEnqueueHandler());
    }
}

