/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue;

import io.advantageous.qbit.Output;
import io.advantageous.qbit.service.Startable;
import io.advantageous.qbit.service.Stoppable;
import java.util.Collection;

public interface SendQueue<T>
extends Output,
Startable,
Stoppable {
    default public boolean send(T item) {
        return true;
    }

    default public void sendAndFlush(T item) {
        this.send(item);
        this.flushSends();
    }

    default public void sendMany(T ... items) {
        for (T i : items) {
            this.send(i);
        }
    }

    default public void sendBatch(Collection<T> items) {
        for (T i : items) {
            this.send(i);
        }
    }

    default public void sendBatch(Iterable<T> items) {
        for (T i : items) {
            this.send(i);
        }
    }

    default public boolean shouldBatch() {
        return true;
    }

    default public void flushSends() {
    }

    default public int size() {
        return 0;
    }

    default public String name() {
        return "NO OP";
    }
}

