/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue.impl;

import io.advantageous.qbit.queue.QueueException;
import io.advantageous.qbit.queue.UnableToEnqueueHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class AddTimeoutUnableToEnqueueHandler
implements UnableToEnqueueHandler {
    private final int timeout;
    private final TimeUnit timeUnit;

    public AddTimeoutUnableToEnqueueHandler(int timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public boolean unableToEnqueue(BlockingQueue<Object> queue, String name, Object item) {
        try {
            if (!queue.offer(item, this.timeout, this.timeUnit)) {
                throw new QueueException("QUEUE FULL: After timeout Unable to send messages to queue " + this);
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new QueueException("QUEUE FULL: Unable to send messages to queue " + name);
        }
    }

    public String toString() {
        return "AddTimeoutUnableToEnqueueHandler{timeout=" + this.timeout + ", timeUnit=" + (Object)((Object)this.timeUnit) + '}';
    }
}

