/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue.impl;

import io.advantageous.qbit.concurrent.PeriodicScheduler;
import io.advantageous.qbit.queue.SendQueue;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class AutoFlushingSendQueue<T>
implements SendQueue<T> {
    private final SendQueue<T> sendQueue;
    private final ReentrantLock lock = new ReentrantLock();
    private PeriodicScheduler periodicScheduler;
    private ScheduledFuture scheduledFuture;

    public AutoFlushingSendQueue(SendQueue<T> sendQueue, PeriodicScheduler periodicScheduler, int interval, TimeUnit timeUnit) {
        this.sendQueue = sendQueue;
        this.periodicScheduler = periodicScheduler;
        this.scheduledFuture = periodicScheduler.repeat(() -> this.flushSends(), interval, timeUnit);
    }

    @Override
    public void stop() {
        this.scheduledFuture.cancel(true);
    }

    @Override
    public boolean send(T item) {
        try {
            this.lock.lock();
            boolean bl = this.sendQueue.send(item);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sendAndFlush(T item) {
        try {
            this.lock.lock();
            this.sendQueue.sendAndFlush(item);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.sendQueue.size();
    }

    @Override
    @SafeVarargs
    public final void sendMany(T ... items) {
        try {
            this.lock.lock();
            this.sendQueue.sendMany(items);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sendBatch(Collection<T> items) {
        try {
            this.lock.lock();
            this.sendQueue.sendBatch(items);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sendBatch(Iterable<T> items) {
        try {
            this.lock.lock();
            this.sendQueue.sendBatch(items);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean shouldBatch() {
        return this.sendQueue.shouldBatch();
    }

    @Override
    public void flushSends() {
        try {
            this.lock.lock();
            this.sendQueue.flushSends();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String name() {
        return this.sendQueue.name();
    }
}

