/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue.impl;

import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.ConstructorAccess;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.ReceiveQueue;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.queue.ReceiveQueueManager;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.queue.UnableToEnqueueHandler;
import io.advantageous.qbit.queue.impl.BasicReceiveQueue;
import io.advantageous.qbit.queue.impl.BasicReceiveQueueManager;
import io.advantageous.qbit.queue.impl.sender.BasicBlockingQueueSender;
import io.advantageous.qbit.queue.impl.sender.BasicSendQueueWithTransferQueue;
import io.advantageous.qbit.queue.impl.sender.BasicSendQueueWithTryTransfer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicQueue<T>
implements Queue<T> {
    private final BlockingQueue<Object> queue;
    private final int batchSize;
    private final Logger logger = LoggerFactory.getLogger(BasicQueue.class);
    private final boolean debug = this.logger.isDebugEnabled();
    private ReceiveQueueManager<T> receiveQueueManager;
    private final String name;
    private final int pollTimeWait;
    private final TimeUnit pollTimeTimeUnit;
    private final AtomicBoolean stop = new AtomicBoolean(true);
    private final Supplier<SendQueue<T>> sendQueueSupplier;

    public BasicQueue(String name, int waitTime, TimeUnit timeUnit, int batchSize, Class<? extends BlockingQueue> queueClass, boolean checkIfBusy, int size, int checkEvery, boolean tryTransfer, UnableToEnqueueHandler unableToEnqueueHandler) {
        this.logger.info("Queue created {} {} batchSize {} size {} checkEvery {} tryTransfer {} waitTime {}", new Object[]{name, queueClass, batchSize, size, checkEvery, tryTransfer, waitTime});
        this.name = name;
        this.pollTimeWait = waitTime;
        this.pollTimeTimeUnit = timeUnit;
        this.batchSize = batchSize;
        if (size == -1) {
            this.queue = (BlockingQueue)ClassMeta.classMeta(queueClass).noArgConstructor().create(new Object[0]);
        } else {
            ClassMeta classMeta = ClassMeta.classMeta(queueClass);
            if (queueClass != LinkedTransferQueue.class) {
                if (this.debug) {
                    this.logger.debug("Not a LinkedTransfer queue");
                }
                ConstructorAccess constructor = classMeta.declaredConstructor(Integer.TYPE);
                this.queue = (BlockingQueue)constructor.create(new Object[]{size});
            } else {
                ConstructorAccess constructorAccess = classMeta.noArgConstructor();
                this.queue = (BlockingQueue)constructorAccess.create(new Object[0]);
            }
        }
        this.sendQueueSupplier = this.queue instanceof LinkedTransferQueue ? (tryTransfer ? () -> new BasicSendQueueWithTryTransfer(name, batchSize, (TransferQueue)this.queue, checkEvery, this) : () -> new BasicSendQueueWithTransferQueue(name, batchSize, (TransferQueue)this.queue, checkEvery, this)) : () -> new BasicBlockingQueueSender(name, batchSize, this.queue, checkIfBusy, unableToEnqueueHandler, this);
        this.logger.info("Queue done creating {} batchSize {} checkEvery {} tryTransfer {}pollTimeWait/polltime {}", new Object[]{this.name, this.batchSize, checkEvery, tryTransfer, this.pollTimeWait});
    }

    @Override
    public ReceiveQueue<T> receiveQueue() {
        if (this.debug) {
            this.logger.debug("ReceiveQueue requested for {}", (Object)this.name);
        }
        return new BasicReceiveQueue(this.queue, this.pollTimeWait, this.pollTimeTimeUnit, this.batchSize);
    }

    @Override
    public SendQueue<T> sendQueue() {
        if (this.debug) {
            this.logger.debug("SendQueue requested for {}", (Object)this.name);
        }
        return this.sendQueueSupplier.get();
    }

    @Override
    public void startListener(ReceiveQueueListener<T> listener) {
        this.receiveQueueManager = new BasicReceiveQueueManager(this.name);
        this.stop.set(false);
        this.logger.info("Starting queue listener for  {} {}", (Object)this.name, listener);
        this.receiveQueueManager.addQueueToManage(this.name, this.receiveQueue(), listener, this.batchSize);
        this.receiveQueueManager.start();
    }

    @Override
    public void stop() {
        this.logger.info("Stopping queue  {}", (Object)this.name);
        this.stop.set(true);
        if (this.receiveQueueManager != null) {
            this.receiveQueueManager.stop();
        }
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean started() {
        return !this.stop.get();
    }

    public String toString() {
        return "BasicQueue{name='" + this.name + '\'' + '}';
    }

    @Override
    public String name() {
        return this.name;
    }
}

