/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue.impl;

import io.advantageous.qbit.queue.ReceiveQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class BasicReceiveQueue<T>
implements ReceiveQueue<T> {
    private final long waitTime;
    private final TimeUnit timeUnit;
    private final int batchSize;
    private final BlockingQueue<Object> queue;
    private Object[] lastQueue = null;
    private int lastQueueIndex;

    public BasicReceiveQueue(BlockingQueue<Object> queue, long waitTime, TimeUnit timeUnit, int batchSize) {
        this.queue = queue;
        this.waitTime = waitTime;
        this.timeUnit = timeUnit;
        this.batchSize = batchSize;
    }

    @Override
    public T pollWait() {
        if (this.lastQueue != null) {
            return this.getItemFromLocalQueue();
        }
        try {
            Object o = this.queue.poll(this.waitTime, this.timeUnit);
            return this.extractItem(o);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
    }

    private T getItemFromLocalQueue() {
        if (this.lastQueue.length == 0) {
            this.lastQueue = null;
            return null;
        }
        Object item = this.lastQueue[this.lastQueueIndex];
        ++this.lastQueueIndex;
        if (this.lastQueueIndex == this.lastQueue.length) {
            this.lastQueueIndex = 0;
            this.lastQueue = null;
        }
        return (T)item;
    }

    @Override
    public T poll() {
        if (this.lastQueue != null) {
            return this.getItemFromLocalQueue();
        }
        Object o = this.queue.poll();
        return this.extractItem(o);
    }

    @Override
    public T take() {
        if (this.lastQueue != null) {
            return this.getItemFromLocalQueue();
        }
        try {
            Object o = this.queue.take();
            return this.extractItem(o);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
    }

    private T extractItem(Object o) {
        if (o instanceof Object[]) {
            this.lastQueue = (Object[])o;
            return this.getItemFromLocalQueue();
        }
        return (T)o;
    }

    @Override
    public Iterable<T> readBatch(int max) {
        T item = this.poll();
        if (item == null) {
            return Collections.emptyList();
        }
        ArrayList<T> batch = new ArrayList<T>();
        batch.add(item);
        while ((item = this.poll()) != null) {
            batch.add(item);
        }
        return batch;
    }

    @Override
    public Iterable<T> readBatch() {
        return this.readBatch(this.batchSize);
    }

    public int hashCode() {
        return this.queue.hashCode();
    }
}

