/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue.impl;

import io.advantageous.qbit.concurrent.ExecutorContext;
import io.advantageous.qbit.concurrent.ScheduledExecutorBuilder;
import io.advantageous.qbit.queue.ReceiveQueue;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.queue.ReceiveQueueManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicReceiveQueueManager<T>
implements ReceiveQueueManager<T> {
    private final Logger logger = LoggerFactory.getLogger(BasicReceiveQueueManager.class);
    private final boolean debug = this.logger.isDebugEnabled();
    private final String name;
    private ExecutorContext executorContext;
    private final AtomicBoolean stop = new AtomicBoolean();
    private QueueInfo<T> queueInfo;

    public BasicReceiveQueueManager(String name) {
        this.name = name;
    }

    @Override
    public void start() {
        this.executorContext = ScheduledExecutorBuilder.scheduledExecutorBuilder().setThreadName("QueueListener|" + this.name).setInitialDelay(50).setPeriod(50).setRunnable(this::manageQueue).build();
        this.executorContext.start();
    }

    private void manageQueue() {
        if (this.queueInfo == null) {
            return;
        }
        String name = this.queueInfo.name;
        ReceiveQueue inputQueue = this.queueInfo.inputQueue;
        ReceiveQueueListener listener = this.queueInfo.listener;
        int batchSize = this.queueInfo.batchSize;
        listener.init();
        Object item = inputQueue.poll();
        int count = 0;
        while (true) {
            if (item != null) {
                listener.startBatch();
            }
            while (item != null) {
                listener.receive(item);
                if (++count >= batchSize) {
                    if (this.debug) {
                        this.logger.debug("BasicReceiveQueueManager {} limit reached batch size = {}", (Object)name, (Object)batchSize);
                    }
                    listener.limit();
                    if (this.stop.get()) {
                        listener.shutdown();
                        return;
                    }
                    count = 0;
                }
                item = inputQueue.poll();
                ++count;
            }
            count = 0;
            listener.empty();
            item = inputQueue.pollWait();
            if (item != null) continue;
            if (this.stop.get()) {
                listener.shutdown();
                return;
            }
            listener.idle();
        }
    }

    @Override
    public void stop() {
        this.stop.set(true);
        if (this.executorContext != null) {
            this.executorContext.stop();
        }
    }

    @Override
    public void addQueueToManage(String name, ReceiveQueue<T> inputQueue, ReceiveQueueListener<T> listener, int batchSize) {
        this.queueInfo = new QueueInfo(name, inputQueue, listener, batchSize);
    }

    private static final class QueueInfo<T> {
        final String name;
        final ReceiveQueue<T> inputQueue;
        final ReceiveQueueListener<T> listener;
        final int batchSize;

        private QueueInfo(String name, ReceiveQueue<T> inputQueue, ReceiveQueueListener<T> listener, int batchSize) {
            this.name = name;
            this.inputQueue = inputQueue;
            this.listener = listener;
            this.batchSize = batchSize;
        }
    }
}

