/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue.impl.sender;

import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.queue.impl.sender.SenderHelperMethods;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;

public abstract class AbstractBasicSendQueue<T>
implements SendQueue<T> {
    protected final BlockingQueue<Object> queue;
    protected final Queue<T> owner;
    protected final int batchSize;
    private final Logger logger;
    protected int checkEveryStarted = 0;
    protected int index;
    protected final String name;
    protected final Object[] queueLocal;

    public AbstractBasicSendQueue(BlockingQueue<Object> queue, Queue<T> owner, int batchSize, String name, Logger logger) {
        this.queue = queue;
        this.owner = owner;
        this.batchSize = batchSize;
        this.name = name;
        this.queueLocal = new Object[batchSize];
        this.logger = logger;
    }

    protected abstract boolean flushIfOverBatch();

    protected abstract boolean sendArray(Object[] var1);

    @Override
    public boolean shouldBatch() {
        return true;
    }

    @Override
    public final boolean send(T item) {
        this.checkStarted();
        boolean ableToSend = this.flushIfOverBatch();
        this.queueLocal[this.index] = item;
        ++this.index;
        return ableToSend;
    }

    private void checkStarted() {
        if (this.checkEveryStarted % 100 == 0 && !this.owner.started()) {
            this.logger.warn("{} :: name {} send queue NOT STARTED", (Object)this.getClass().getSimpleName(), (Object)this.name);
        }
        ++this.checkEveryStarted;
    }

    @Override
    public final void sendAndFlush(T item) {
        this.checkStarted();
        this.send(item);
        this.flushSends();
    }

    @Override
    @SafeVarargs
    public final void sendMany(T ... items) {
        this.checkStarted();
        this.flushSends();
        this.sendArray(items);
    }

    @Override
    public final void sendBatch(Iterable<T> items) {
        this.checkStarted();
        this.flushSends();
        Object[] array = SenderHelperMethods.objectArrayFromIterable(items);
        this.sendArray(array);
    }

    @Override
    public final void sendBatch(Collection<T> items) {
        this.checkStarted();
        this.flushSends();
        Object[] array = SenderHelperMethods.objectArrayFromCollection(items);
        this.sendArray(array);
    }

    public final int hashCode() {
        return this.queue.hashCode();
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final int size() {
        return this.queue.size();
    }

    @Override
    public final void flushSends() {
        this.sendLocalQueue();
    }

    protected final boolean sendLocalQueue() {
        if (this.index > 0) {
            Object[] copy = SenderHelperMethods.fastObjectArraySlice(this.queueLocal, 0, this.index);
            boolean ableToSend = this.sendArray(copy);
            this.index = 0;
            return ableToSend;
        }
        return false;
    }
}

