/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue.impl.sender;

import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.UnableToEnqueueHandler;
import io.advantageous.qbit.queue.impl.sender.AbstractBasicSendQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TransferQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicBlockingQueueSender<T>
extends AbstractBasicSendQueue<T> {
    private final Logger logger = LoggerFactory.getLogger(BasicBlockingQueueSender.class);
    private final UnableToEnqueueHandler unableToEnqueueHandler;

    public BasicBlockingQueueSender(String name, int batchSize, BlockingQueue<Object> queue, boolean checkBusy, UnableToEnqueueHandler unableToEnqueueHandler, Queue<T> owner) {
        super(queue, owner, batchSize, name + "| BQ SEND QUEUE", LoggerFactory.getLogger(BasicBlockingQueueSender.class));
        this.unableToEnqueueHandler = unableToEnqueueHandler;
        if (queue instanceof TransferQueue && checkBusy) {
            throw new IllegalStateException("Should never pass transfer queue");
        }
    }

    @Override
    protected final boolean flushIfOverBatch() {
        return this.index < this.batchSize || this.sendLocalQueue();
    }

    @Override
    protected final boolean sendArray(Object[] array) {
        if (!this.queue.offer(array)) {
            this.logger.error("Unable to send to queue {}  Size of queue {} ", (Object)this.name, (Object)this.queue.size());
            return this.unableToEnqueueHandler.unableToEnqueue(this.queue, this.name, array);
        }
        return true;
    }
}

